/* $Id: client-file-info.h,v 1.1 2006/01/01 07:24:34 lace Exp $
 * Include file with client-application 'file' access to libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_FILE_INFO_H
#define _CAPTIVE_CLIENT_FILE_INFO_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-file-info.h>	/* for GnomeVFSFileInfo*/


G_BEGIN_DECLS

#define CAPTIVE_FILE_INFO_TYPE_OBJECT            (captive_file_info_object_get_type())
#define CAPTIVE_FILE_INFO_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_FILE_INFO_TYPE_OBJECT,CaptiveFileInfoObject))
#define CAPTIVE_FILE_INFO_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_FILE_INFO_TYPE_OBJECT,CaptiveFileInfoObjectClass))
#define CAPTIVE_FILE_INFO_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_FILE_INFO_TYPE_OBJECT))
#define CAPTIVE_FILE_INFO_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_FILE_INFO_TYPE_OBJECT))
#define CAPTIVE_FILE_INFO_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_FILE_INFO_TYPE_OBJECT,CaptiveFileInfoObjectClass))
typedef struct _CaptiveFileInfoObject      CaptiveFileInfoObject;
typedef struct _CaptiveFileInfoObjectClass CaptiveFileInfoObjectClass;


struct _CaptiveFileInfoObject {
	GObject parent_instance;

	/*< public >*/
	GnomeVFSFileInfo p;
	/* Unsupported by GnomeVFS, see: http://bugzilla.gnome.org/show_bug.cgi?id=325427 */
	guint atime_nsec;	/* Valid if: p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_ATIME */
	guint mtime_nsec;	/* Valid if: p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_MTIME */
	guint ctime_nsec;	/* Valid if: p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_CTIME */
	};


GType captive_file_info_object_get_type(void);

GnomeVFSResult captive_file_info_object_new(CaptiveFileInfoObject **captive_file_info_object_return);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_FILE_INFO_H */
