/* $Id: client-file.h,v 1.12 2006/01/01 07:24:34 lace Exp $
 * Include file with client-application 'file' access to libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_FILE_H
#define _CAPTIVE_CLIENT_FILE_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-handle.h>	/* for GnomeVFSOpenMode */
#include "captive/client-vfs.h"
#include "captive/client-file-info.h"


G_BEGIN_DECLS

#define CAPTIVE_FILE_TYPE_OBJECT            (captive_file_object_get_type())
#define CAPTIVE_FILE_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_FILE_TYPE_OBJECT,CaptiveFileObject))
#define CAPTIVE_FILE_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_FILE_TYPE_OBJECT,CaptiveFileObjectClass))
#define CAPTIVE_FILE_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_FILE_TYPE_OBJECT))
#define CAPTIVE_FILE_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_FILE_TYPE_OBJECT))
#define CAPTIVE_FILE_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_FILE_TYPE_OBJECT,CaptiveFileObjectClass))
typedef struct _CaptiveFileObject      CaptiveFileObject;
typedef struct _CaptiveFileObjectClass CaptiveFileObjectClass;


GType captive_file_object_get_type(void);

GnomeVFSResult captive_file_new_open(CaptiveFileObject **captive_file_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode);
GnomeVFSResult captive_file_new_create(CaptiveFileObject **captive_file_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode,gboolean exclusive,guint perm);
CaptiveVfsObject *captive_file_ref_vfs(CaptiveFileObject *captive_file_object);
GnomeVFSResult captive_file_read(CaptiveFileObject *captive_file_object,
		gpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_read_return);
GnomeVFSResult captive_file_write(CaptiveFileObject *captive_file_object,
		gconstpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_written_return);
GnomeVFSResult captive_file_seek
		(CaptiveFileObject *captive_file_object,GnomeVFSSeekPosition whence,GnomeVFSFileOffset offset);
GnomeVFSResult captive_file_tell(CaptiveFileObject *captive_file_object,GnomeVFSFileOffset *offset_return);
GnomeVFSResult captive_file_remove(CaptiveFileObject *captive_file_object);
GnomeVFSResult captive_file_file_info_get(CaptiveFileObject *captive_file_object,
		CaptiveFileInfoObject **captive_file_info_object_return);
GnomeVFSResult captive_file_file_info_set(CaptiveFileObject *captive_file_object,
		CaptiveFileInfoObject *captive_file_info_object,GnomeVFSSetFileInfoMask mask);
GnomeVFSResult captive_file_truncate(CaptiveFileObject *captive_file_object,GnomeVFSFileSize file_size);
GnomeVFSResult captive_file_move(CaptiveFileObject *captive_file_object_old,const gchar *pathname_new,gboolean force_replace);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_FILE_H */
