/* $Id: client-vfs.h,v 1.3 2003/08/28 21:24:45 short Exp $
 * Include file with client general VFS access to libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_VFS_H
#define _CAPTIVE_CLIENT_VFS_H 1


#include <glib/gtypes.h>
#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include "captive/options.h"	/* for captive_options */


G_BEGIN_DECLS

#define CAPTIVE_VFS_TYPE_OBJECT            (captive_vfs_object_get_type())
#define CAPTIVE_VFS_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_VFS_TYPE_OBJECT,CaptiveVfsObject))
#define CAPTIVE_VFS_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_VFS_TYPE_OBJECT,CaptiveVfsObjectClass))
#define CAPTIVE_VFS_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_VFS_TYPE_OBJECT))
#define CAPTIVE_VFS_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_VFS_TYPE_OBJECT))
#define CAPTIVE_VFS_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_VFS_TYPE_OBJECT,CaptiveVfsObjectClass))
typedef struct _CaptiveVfsObject      CaptiveVfsObject;
typedef struct _CaptiveVfsObjectClass CaptiveVfsObjectClass;


GType captive_vfs_object_get_type(void);

struct captive_options;

typedef struct _CaptiveVfsVolumeInfo CaptiveVfsVolumeInfo;
struct _CaptiveVfsVolumeInfo {
	guint32 block_size;
	guint64 bytes;
	guint64 bytes_free;	/* total free */
	guint64 bytes_available;	/* free without reserved */
	};


GnomeVFSResult captive_vfs_new
		(CaptiveVfsObject **captive_vfs_object_return,const struct captive_options *options);
GnomeVFSResult captive_vfs_commit(CaptiveVfsObject *captive_vfs_object);
GnomeVFSResult captive_vfs_volume_info_get(CaptiveVfsObject *captive_vfs_object,CaptiveVfsVolumeInfo *volume_info);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_VFS_H */
