/* $Id: config2.h,v 1.3 2005/12/22 10:01:43 lace Exp $
 * Supplemental include file for config.h of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CONFIG2_H
#define _CAPTIVE_CONFIG2_H 1


/* Prevent: /usr/include/libbonobo-2.0/bonobo/bonobo-i18n.h:47:1: warning: "_" redefined */
/* #undef's need to be out of AH_BOTTOM() of 'configure.ac' to not to be commented out. */
#ifdef CAPTIVE_USING_GNOMEUI
# include <bonobo/bonobo-i18n.h>
# undef textdomain
# undef gettext
# undef dgettext
# undef dcgettext
# undef bindtextdomain
# undef bind_textdomain_codeset
# undef _
# undef N_
#endif /* CAPTIVE_USING_GNOMEUI */
#ifdef ENABLE_NLS
/* <libintl.h> is taken from "$(top_srcdir)/intl" if system doesn't provide intl */
#	include <libintl.h>
#ifdef LIBCAPTIVE
#	define _(String) dgettext (PACKAGE,String)
#else
#	define _(String) gettext (String)
#endif /* LIBCAPTIVE */
#	ifdef gettext_noop
#		define N_(String) gettext_noop (String)
#	else
#		define N_(String) (String)
#	endif
#else /* !ENABLE_NLS */
/* Stubs that do something close enough.  */
#	define textdomain(String) (String)
#	define gettext(String) (String)
#	define dgettext(Domain,Message) (Message)
#	define dcgettext(Domain,Message,Type) (Message)
#	define bindtextdomain(Domain,Directory) (Domain)
#	define _(String) (String)
#	define N_(String) (String)
#endif /* !ENABLE_NLS */

#include <glib/gtypes.h>	/* for 'gchar' */
/* Prevent: /usr/include/glib-2.0/glib/gmessages.h:123:1: warning: this is the location of the previous definition */
#undef G_LOG_DOMAIN
#define G_LOG_DOMAIN ((const gchar *)"Captive")

/* Ensure we have proper -I options: */
#if defined(CAPTIVE_USE_GNOME_VFS_MODULE) || defined(CAPTIVE_USE_GNOME_VFS)
#ifndef HAVE_GNOME_VFS_READ_ENTIRE_FILE
#include <libgnomevfs/gnome-vfs-result.h>
GnomeVFSResult gnome_vfs_read_entire_file(const char *uri,int *file_size,char **file_contents);
#endif
#endif

/* We need to redefine it here as any '#undef' in config.h gets commented
 * out during 'config.h.in' -> 'config.h' pass.
 */
#if defined(__GNUC__) && (__GNUC__ >= 3)
#include <glib/gmacros.h>	/* for 'G_STRLOC' */
#  undef  G_STRLOC
/* '__func__' does not string-concatenate! */
#  define G_STRLOC	__func__
#endif


/* g_log() and g_logv() acceleration */
#ifdef LIBCAPTIVE
#include <glib/gmessages.h>	/* for g_log() */
#include <glib/gtypes.h>	/* for 'gboolean' */
extern gboolean captive_debug_messages_disabled;
#define g_log(log_domain,log_level,format,args...) ({ \
		GLogLevelFlags _captive_g_log_log_level=(log_level); \
		if ((_captive_g_log_log_level&~(G_LOG_LEVEL_MESSAGE|G_LOG_LEVEL_INFO|G_LOG_LEVEL_DEBUG)) \
				|| !captive_debug_messages_disabled) \
			g_log((log_domain),_captive_g_log_log_level,(format) , ## args); \
		})
#define g_logv(log_domain,log_level,format,args) ({ \
		GLogLevelFlags _captive_g_logv_log_level=(log_level); \
		if ((_captive_g_logv_log_level&~(G_LOG_LEVEL_MESSAGE|G_LOG_LEVEL_INFO|G_LOG_LEVEL_DEBUG)) \
				|| !captive_debug_messages_disabled) \
			g_logv((log_domain),_captive_g_logv_log_level,(format),(args)); \
		})
#endif /* LIBCAPTIVE */


#endif /* _CAPTIVE_CONFIG2_H */
