/* $Id: ldr.h,v 1.6 2003/06/07 07:12:30 short Exp $
 * Include file for reactos ldr/ (loader) emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_LDR_H
#define _CAPTIVE_LDR_H 1


#include "captive/ldr.h"	/* self */
#include <glib/gmacros.h>
#include "reactos/internal/ldr.h"
#include <glib/gtypes.h>
#include "captive/options-module.h"


G_BEGIN_DECLS

NTSTATUS captive_LdrpLoadAndCallImage(PMODULE_OBJECT *ModuleObjectp,struct captive_options_module *options_module,
		PDRIVER_OBJECT DriverEntry_DriverObject,PUNICODE_STRING DriverEntry_RegistryPath);
NTSTATUS captive_LdrLoadModule(struct captive_options_module *options_module,PMODULE_OBJECT *ModuleObjectp);
struct captive_ModuleList_patchpoint *captive_ModuleList_patchpoint_find(gconstpointer ExportAddress);
G_CONST_RETURN gchar *captive_ModuleList_function_disable_find(gconstpointer ExportAddress);
void *captive_Module_GetExportAddress(const gchar *ModuleName_utf8,const gchar *FunctionName);

/* reactos/ntoskrnl/ldr/loader.c file-scope global declaration: */
/* Newlines prevent their inclusion by gtk-doc. */
extern
		LIST_ENTRY ModuleListHead;
extern
		KSPIN_LOCK ModuleListLock;
extern
		LIST_ENTRY ModuleTextListHead;

/* po/shutdownwork.c: */
void captive_PoQueueShutdownWorkItem_hooklist_invoke(void);

G_END_DECLS


#endif /* _CAPTIVE_LDR_H */
