/* $Id: ldr_exports.h,v 1.3 2003/10/28 18:58:46 short Exp $
 * Include file for reactos ldr/ (loader) to be used from ke/exports.c of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_LDR_EXPORTS_H
#define _CAPTIVE_LDR_EXPORTS_H 1


#include <glib/gtypes.h>
/* NEVER include any captive/reactos include file as we are included
 * from libcaptive/ke/exports.c which conflicts on any export symbol declaration.
 */


G_BEGIN_DECLS

/**
 * captive_kernel_exports:
 *
 * Export complete libcaptive modules to reactos. It is done by *.def files used
 * by dlltool(1) of Mingw32 compiler suite. We use native host OS compiler and
 * we also have just a limited set of functions over reactos itself.
 * We use our captive_ModuleList_add_builtin() to simulate PE headers exporting
 * our symbols; this export simulation is invocated from this function.
 *
 * This function is generated automatically from #exports.captivesym file
 * by #captivesym.pl script.
 *
 * Multiple calls of this function are forbidden. See also captive_kernel_patches().
 *
 * Returns: %TRUE if the export was successful.
 */
gboolean captive_kernel_exports(void);


/**
 * captive_kernel_patches_debug:
 *
 * Patches W32 libraries by libcaptive functions. It is done by *.def files used
 * by dlltool(1) of Mingw32 compiler suite. We use native host OS compiler and
 * we also have just a limited set of functions over reactos itself.
 * We use our captive_ModuleList_patch() to modify existing module function
 * tables generated from captive_ModuleList_add_builtin().
 *
 * This function is generated automatically from #exports.captivesym file
 * by #captivesym.pl script.
 *
 * This function is used in --debug-messages mode as it also patches 'pass'
 * functions to be successfuly debug dumped.
 *
 * Multiple calls of this function are forbidden. See also captive_kernel_exports().
 *
 * Returns: %TRUE if the export was successful.
 */
gboolean captive_kernel_patches_debug(void);


/**
 * captive_kernel_patches_nondebug:
 *
 * Function equivalent to captive_kernel_patches_debug() but it does not patch
 * 'pass' functions as they are not needed to be traced if no --debug-messages
 * was specified. See captive_kernel_patches_debug() for the description
 * of this function.
 *
 * Returns: %TRUE if the export was successful.
 */
gboolean captive_kernel_patches_nondebug(void);


struct captive_ModuleList_patchpoint {
	guint8 *orig_w32_func;	/* direct pointer to W32 binary entry point */
	guint8 *orig_w32_2ndinstr;	/* direct pointer to W32 binary second instruction after entry point */
	void (*wrap_wrap_func)(void);	/* address of 'exports.c' debug-printing outer function */
	guint8 orig_w32_func_byte;
	guint8 orig_w32_2ndinstr_byte;
	gboolean through_w32_func;	/* pass once through 'orig_w32_func' entry point without redirection to 'wrap_wrap_func' */
	};

gboolean captive_ModuleList_add_builtin(const gchar *FullName_utf8,...);
gboolean captive_ModuleList_patch(const gchar *FullName_utf8,...);

G_END_DECLS


#endif /* _CAPTIVE_LDR_EXPORTS_H */
