/* $Id: libxml.h,v 1.3 2005/12/17 05:19:13 lace Exp $
 * Include file for supplementary captive utilities for libxml2
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_LIBXML_H
#define _CAPTIVE_LIBXML_H 1


#include <glib/gtypes.h>
#include <libxml/tree.h>	/* for xmlChar */


G_BEGIN_DECLS

enum captive_xml_text_reader_node_type {
	CAPTIVE_XML_TEXT_READER_NODE_TYPE_START=1,
	CAPTIVE_XML_TEXT_READER_NODE_TYPE_TEXT=3,
	CAPTIVE_XML_TEXT_READER_NODE_TYPE_COMMENT=8,
	CAPTIVE_XML_TEXT_READER_NODE_TYPE_SIGNIFICANT_WHITESPACE=14,
	CAPTIVE_XML_TEXT_READER_NODE_TYPE_END=15,
	};

struct captive_libxml_string_drop_stack;

gint64 captive_libxml_sscanf_gint64(const char *gint64_string);
G_CONST_RETURN gchar *captive_libxml_string_drop(struct captive_libxml_string_drop_stack **drop_stackp,const xmlChar *xml_string);
void captive_libxml_string_drop_flush(struct captive_libxml_string_drop_stack **drop_stackp);

G_END_DECLS


#endif /* _CAPTIVE_LIBXML_H */
