/* $Id: options-module.h,v 1.2 2003/07/04 15:06:35 short Exp $
 * Include file with captive_options_module definition of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_OPTIONS_MODULE_H
#define _CAPTIVE_CLIENT_OPTIONS_MODULE_H 1


#include <glib/gtypes.h>
#include <glib/giochannel.h>
#include <popt.h>
#include <glib/glist.h>


G_BEGIN_DECLS

enum captive_options_module_type {
	CAPTIVE_OPTIONS_MODULE_TYPE_EMPTY,
	CAPTIVE_OPTIONS_MODULE_TYPE_PE32,
	CAPTIVE_OPTIONS_MODULE_TYPE_GMODULE,
	};

struct captive_options_module {
	gchar *pathname_utf8;
	enum captive_options_module_type type;
	union {
		struct {
			guint8 *base;
			size_t length;
			gboolean mapped;	/* otherwise g_malloc()ed */
			gchar *md5;
			} pe32;
		struct {
			gchar *pathname;
			} gmodule;
		} u;
	};

/* Functions handle just the fields, not the structure itself. */
gboolean captive_options_module_load(struct captive_options_module *options_module,const gchar *pathname_utf8);
void captive_options_module_copy(struct captive_options_module *dest,const struct captive_options_module *src);
void captive_options_module_free(struct captive_options_module *options_module);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_OPTIONS_MODULE_H */
