/* $Id: options.h,v 1.10 2005/12/27 09:05:29 lace Exp $
 * Include file with captive_options definition of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_OPTIONS_H
#define _CAPTIVE_CLIENT_OPTIONS_H 1


#include <glib/gtypes.h>
#include <glib/giochannel.h>
#include <popt.h>
#include <glib/glist.h>
#include "captive/options-module.h"
#include "captive/captivemodid.h"


G_BEGIN_DECLS

extern const struct poptOption captive_popt[];
#define CAPTIVE_POPT_INCLUDE \
		{ NULL,'\0',POPT_ARG_INCLUDE_TABLE,(struct poptOption *)&captive_popt,0,"Captive" }


enum captive_option_rwmode {
	CAPTIVE_OPTION_RWMODE_RO,
	CAPTIVE_OPTION_RWMODE_BLIND,
	CAPTIVE_OPTION_RWMODE_RW,
	};
typedef
		enum captive_option_rwmode captive_option_rwmode_t;

enum captive_option_media {
	CAPTIVE_OPTION_MEDIA_UNKNOWN,
	CAPTIVE_OPTION_MEDIA_CDROM,
	CAPTIVE_OPTION_MEDIA_DISK,
	};

struct captive_options {
	struct captive_options_module filesystem;
	enum captive_option_rwmode rwmode;
	enum captive_option_media media;
	gboolean debug_messages;
	GIOChannel *image_iochannel;
	GList *load_module;	/* of 'struct captive_options_module *' */
	gboolean sandbox;
	char **sandbox_server_argv;
	gchar *sandbox_server_ior;
	gchar *bug_pathname;
	int syslog_facility;	/* LOG_*; -1 if not used */
#ifdef HAVE_LIBXML_XMLREADER_H
	CaptiveCaptivemodidObject *captivemodid;
#endif /* HAVE_LIBXML_XMLREADER_H */
	gboolean load_untested;
	};

/**
 * captive_options:
 *
 * Current options set in one CORBA sandboxed child.
 * It is also set when run in non-CORBA debugging mode.
 * Set to %NULL in the CORBA master process.
 */
extern struct captive_options *captive_options;

/* Functions handle just the fields, not the structure itself. */
void captive_options_init(struct captive_options *options);
void captive_options_copy(struct captive_options *dest,const struct captive_options *src);
void captive_options_free(struct captive_options *options);
gboolean captive_options_parse(struct captive_options *options,const gchar *captive_args);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_OPTIONS_H */
