/* $Id: ps_reactos.h,v 1.1 2002/10/31 17:37:52 short Exp $
 * Include file for processor support used also for reactos files for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_PS_REACTOS_H
#define _CAPTIVE_PS_REACTOS_H 1


#include <glib/gmacros.h>
/* captive/?*_reactos.h include files have forbidden any reactos/?* inclusions
 * as they are being included by reactos/compat.h.
 */


G_BEGIN_DECLS

struct _KTHREAD;

/**
 * captive_KPCR:
 *
 * #PCR (Processor Control Region) structure type.
 * Returned by captive_KeGetCurrentKPCR().
 *
 * This structure IS NOT binary compatible with reactos!
 */
typedef struct {
	struct
			/* newline to pass gtkdoc-scan */
			_KTHREAD *CurrentThread;
	} captive_KPCR;

/* NEVER put anything after 'typedef struct' closing '}' as it confuses gtkdoc-scan. */
typedef captive_KPCR *captive_PKPCR;


captive_PKPCR captive_KeGetCurrentKPCR(void);

G_END_DECLS


#endif /* _CAPTIVE_PS_REACTOS_H */
