/* $Id: storage.h,v 1.6 2003/05/04 12:03:33 short Exp $
 * Include file for reactos storage device drivers emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_STORAGE_H
#define _CAPTIVE_STORAGE_H 1


#include <glib/gtypes.h>
#include <glib/giochannel.h>
#include "reactos/ntos/types.h"	/* for ULONG */


G_BEGIN_DECLS

/**
 * captive_image_iochannel
 *
 * The readl #GIOChannel to be used for accessing the disk image.
 * It may be either directly #captive_options->image_iochannel
 * or the wrapper by #giochannel-blind.
 */
extern GIOChannel *captive_image_iochannel;


/**
 * captive_image_size:
 *
 * Size of #captive_image_iochannel. Empty files are rejected and therefore
 * this value is always >0 after successful captive_init().
 * Value is detected by captive_giochannel_size(captive_image_iochannel).
 */
extern guint64 captive_image_size;


guint64 captive_giochannel_size(GIOChannel *channel);
gboolean captive_cdrom_init(void);
gboolean captive_disk_init(void);

G_END_DECLS


#endif /* _CAPTIVE_STORAGE_H */
