/* $Id: unicode.h,v 1.6 2003/02/13 09:52:39 short Exp $
 * Include file for unicode add-ons to reactos ntoskrnl/rtl/unicode.c for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_UNICODE_H
#define _CAPTIVE_UNICODE_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include <glib/galloca.h>
#include "reactos/napi/types.h"  /* for PUNICODE_STRING etc. */
#include "reactos/ntos/rtltypes.h"	/* for ANSI_STRING */
#include <stddef.h>	/* for size_t and wchar_t */
#include <glib/gunicode.h>	/* for gunichar */


G_BEGIN_DECLS

/**
 * captive_UnicodeString_to_utf8_alloca:
 * @string_UnicodeString: #PUNICODE_STRING type of string to convert.
 *
 * alloca(3)-based conversion from #PUNICODE_STRING to plain #utf8 string.
 *
 * @Returns: #const #gchar * alloca(3)ed converted string @string_UnicodeString.
 */
#define captive_UnicodeString_to_utf8_alloca(string_UnicodeString) \
		({ /* GCC dependent */ \
			/* detect required memory size, g_alloca() cannot safely fail (really?) */ \
			gchar *mem=g_alloca(_captive_UnicodeString_to_utf8_alloca_internal_sizeof(string_UnicodeString)); \
			/* convert+copy the string to the prepared memory */ \
			_captive_UnicodeString_to_utf8_alloca_internal_fill(mem,string_UnicodeString); \
			(const gchar *)mem; \
			})
size_t _captive_UnicodeString_to_utf8_alloca_internal_sizeof(const UNICODE_STRING *string_UnicodeString);
void _captive_UnicodeString_to_utf8_alloca_internal_fill(gchar *mem,const UNICODE_STRING *string_UnicodeString);


/**
 * captive_utf8_to_UnicodeString_alloca:
 * @string_utf8: #const #gchar * string in #utf8 to convert.
 *
 * alloca(3)-based conversion from plain #utf8 string to #PUNICODE_STRING.
 *
 * @Returns: #PUNICODE_STRING alloca(3)ed converted string @string_utf8.
 */
#define captive_utf8_to_UnicodeString_alloca(string_utf8) \
		({ /* GCC dependent */ \
			/* detect required memory size, g_alloca() cannot safely fail (really?) */ \
			UNICODE_STRING *mem=g_alloca(_captive_utf8_to_UnicodeString_alloca_internal_sizeof(string_utf8)); \
			/* convert+copy the string to the prepared memory */ \
			_captive_utf8_to_UnicodeString_alloca_internal_fill(mem,string_utf8); \
			(PUNICODE_STRING)mem; \
			})
size_t _captive_utf8_to_UnicodeString_alloca_internal_sizeof(const gchar *string_utf8);
void _captive_utf8_to_UnicodeString_alloca_internal_fill(UNICODE_STRING *mem,const gchar *string_utf8);


gboolean captive_validate_ucs4(const gunichar *string_ucs4);
gboolean captive_validate_ucs2(const captive_ucs2 *string_ucs2);
gboolean captive_validate_ucs2_fixlen(const captive_ucs2 *string_ucs2,glong string_ucs2_fixlen);
gboolean captive_validate_utf8(const gchar *string_utf8);
glong captive_ucs2_strlen(const captive_ucs2 *string_ucs2) G_GNUC_PURE;
gboolean captive_validate_UnicodeString(const UNICODE_STRING *string_UnicodeString);
gboolean captive_validate_UnicodeString_noterm(const UNICODE_STRING *string_UnicodeString_noterm);
gboolean captive_validate_AnsiString(const ANSI_STRING *string_AnsiString);
gchar *captive_UnicodeString_to_utf8_malloc(const UNICODE_STRING *string_UnicodeString);
PUNICODE_STRING captive_utf8_to_UnicodeString_malloc(const gchar *string_utf8);
/* We can be G_GNUC_CONST as we really just map the pointer values.
 * Initially we create the result content from the input content but it should not harm.
 */
const gunichar2 *captive_ucs4_to_utf16_const(const gunichar *string_ucs4) G_GNUC_CONST;
gboolean captive_ucs2_compare(const captive_ucs2 *string_a_ucs2,const captive_ucs2 *string_b_ucs2);
gboolean captive_UnicodeString_compare
		(const UNICODE_STRING *string_a_UnicodeString,const UNICODE_STRING *string_b_UnicodeString);
gboolean captive_ucs2_compare_insensitive(const captive_ucs2 *string_a_ucs2,const captive_ucs2 *string_b_ucs2);
gboolean captive_UnicodeString_compare_insensitive
		(const UNICODE_STRING *string_a_UnicodeString,const UNICODE_STRING *string_b_UnicodeString);

/* internal: */
void captive_FsRtlLegalAnsiCharacterArray_init(void);

G_END_DECLS


#endif /* _CAPTIVE_UNICODE_H */
