/* $Id: unicode_reactos.h,v 1.2 2003/01/11 18:26:00 short Exp $
 * Include file for unicode support used also for reactos files for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_UNICODE_REACTOS_H
#define _CAPTIVE_UNICODE_REACTOS_H 1


#include <glib/gtypes.h>	/* for guint16 */
#include <glib/gunicode.h>	/* for gunichar */
/* captive/?*_reactos.h include files have forbidden any reactos/?* inclusions
 * as they are being included by reactos/compat.h.
 */


G_BEGIN_DECLS

/**
 * captive_ucs2:
 *
 * This type is separated from Gnome #gunichar2 as #captive_ucs2 MUST be used for UCS-2
 * encoded strings in the opposite of #gunichar2 beging used for UTF-16 encoded strings.
 */
typedef guint16 captive_ucs2;


/* We can be G_GNUC_CONST as we really just map the pointer values.
 * Initially we create the result content from the input content but it should not harm.
 */
const captive_ucs2 *captive_ucs4_to_ucs2_const(const gunichar *string_ucs4) G_GNUC_CONST;


/**
 * captive_wchar32_to_ucs2_const:
 * @string_wchar32: #const #wchar_t * type of 32-bit #wchar_t persistent string to convert.
 * This string MUST remain readable with the same content forever.
 * This string MUST be convertible to UCS-2 string.
 *
 * Constant string conversion from 32-bit #wchar_t to 16-bit #wchar_t.
 * You may not modify the result in any way.
 * 
 * It is guaranteed to get two different string addresses for two different
 * input addresses even if the input strings content is the same.
 * Otherwise we would behave as #GCC option %-fmerge-constants which
 * results in %C non-conforming behaviour.
 *
 * This function is a pure pass to captive_ucs4_to_ucs2_const()
 * to implement proper type checking of the passed @string_wchar32.
 *
 * Returns: #const #captive_ucs2 * converted string @string_ucs4.
 */
static inline const captive_ucs2 *captive_wchar32_to_ucs2_const(const wchar_t *string_wchar32) G_GNUC_UNUSED;
static inline const captive_ucs2 *captive_wchar32_to_ucs2_const(const wchar_t *string_wchar32)
{
	return captive_ucs4_to_ucs2_const((const gunichar *)string_wchar32);
}

G_END_DECLS


#endif /* _CAPTIVE_UNICODE_REACTOS_H */
