/* $Id: compat.h,v 1.11 2005/12/17 02:22:24 lace Exp $
 * Include file for GNU world compatibility with reactos include files for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* NEVER protect this include file with #ifndef/#define/#endif
 * wrapper as we need to be included multiple times
 * Despite this we still #define the symbol to be able to check it
 */
#ifdef _CAPTIVE_REACTOS_COMPAT_H
#undef _CAPTIVE_REACTOS_COMPAT_H
#define _CAPTIVE_REACTOS_COMPAT_H 2
#else
#define _CAPTIVE_REACTOS_COMPAT_H 1
#endif

/* NEVER use #include in this file before all the #define-s are done
 * as we pretend any nested #include "reactos/compat.h" automatically as 'succeeded'.
 * NEVER use any #include inside !REACTOS_COMPAT condition branches.
 * We never nest as the include is protected by #ifdef from reactos/?*.h includes.
 */
#ifdef _CAPTIVE_REACTOS_COMPAT_H_INSIDE
#error "$(top_srcdir)/src/libcaptive/include/reactos/compat.h MUST NOT NEST!"
#endif
#define _CAPTIVE_REACTOS_COMPAT_H_INSIDE 1


/* reactos uses __declspec(dllimport) and __declspec(dllexport)
 * which gets expanded to __attribute__($2) by -D in their Makefile GCC commandline.
 */
#ifdef REACTOS_COMPAT
#define __declspec(type)
#else
#undef __declspec
#endif

/* It gets defined to __attribute__((fastcall)) by "ddk/ntddk.h". */
#ifdef REACTOS_COMPAT
#define FASTCALL
#else
#undef FASTCALL
#endif

/* It gets defined to __attribute__((stdcall)) by "base.h" and "ntos/types.h". */
#ifdef REACTOS_COMPAT
#define STDCALL
#else
#undef STDCALL
#endif

/* It gets defined to __attribute__((cdecl)) by "base.h" and "ntos/types.h"; should not hurt. */
#ifdef REACTOS_COMPAT
#define CDECL
#else
#undef CDECL
#endif

/* Get the system declarations as their original names.
 * reactos will use the redefined ones below.
 * If we would include <string.h> later the system declarations would have captive_reactos_*
 * names and system vs. reactos declarations would conflict again - just named captive_reactos_*.
 * FIXME: Unfortunately we cannot include <string.h> twice.
 * If we do "reactos/X.h" include from libcaptive (not reactos)
 * we already lost the possibility to use the optimized
 * system macros as they are #define-d and we #undef them here.
 * Fortunately there should also be a system declarations with the same
 * name and we are satisfied with their non-inlined (=non-#define-d) versions.
 */
#include <string.h>

#ifdef REACTOS_COMPAT
#define wcscpy captive_reactos_wcscpy
#else
#undef wcscpy
#endif

#ifdef REACTOS_COMPAT
#define wcscat captive_reactos_wcscat
#else
#undef wcscat
#endif

#ifdef REACTOS_COMPAT
#define wcschr captive_reactos_wcschr
#else
#undef wcschr
#endif

#ifdef REACTOS_COMPAT
#define wcsrchr captive_reactos_wcsrchr
#else
#undef wcsrchr
#endif

#ifdef REACTOS_COMPAT
#define wcslen captive_reactos_wcslen
#else
#undef wcslen
#endif

#ifdef REACTOS_COMPAT
#define wcscmp captive_reactos_wcscmp
#else
#undef wcscmp
#endif

#ifdef REACTOS_COMPAT
#define _wcsicmp captive_reactos__wcsicmp
#else
#undef _wcsicmp
#endif

#ifdef REACTOS_COMPAT
#define wcsncmp captive_reactos_wcsncmp
#else
#undef wcsncmp
#endif

#ifdef REACTOS_COMPAT
#undef memchr
#define memchr captive_reactos_memchr
#else
#undef memchr
#endif

#ifdef REACTOS_COMPAT
#undef memcpy
#define memcpy captive_reactos_memcpy
#else
#undef memcpy
#endif

#ifdef REACTOS_COMPAT
#undef memmove
#define memmove captive_reactos_memmove
#else
#undef memmove
#endif

#ifdef REACTOS_COMPAT
#undef memset
#define memset captive_reactos_memset
#else
#undef memset
#endif

#ifdef REACTOS_COMPAT
#undef strcat
#define strcat captive_reactos_strcat
#else
#undef strcat
#endif

#ifdef REACTOS_COMPAT
#undef strchr
#define strchr captive_reactos_strchr
#else
#undef strchr
#endif

#ifdef REACTOS_COMPAT
#undef strcmp
#define strcmp captive_reactos_strcmp
#else
#undef strcmp
#endif

#ifdef REACTOS_COMPAT
#undef strcpy
#define strcpy captive_reactos_strcpy
#else
#undef strcpy
#endif

#ifdef REACTOS_COMPAT
#undef strlen
#define strlen captive_reactos_strlen
#else
#undef strlen
#endif

#ifdef REACTOS_COMPAT
#undef strncat
#define strncat captive_reactos_strncat
#else
#undef strncat
#endif

#ifdef REACTOS_COMPAT
#undef strncmp
#define strncmp captive_reactos_strncmp
#else
#undef strncmp
#endif

#ifdef REACTOS_COMPAT
#undef strncpy
#define strncpy captive_reactos_strncpy
#else
#undef strncpy
#endif

#ifdef REACTOS_COMPAT
#undef strrchr
#define strrchr captive_reactos_strrchr
#else
#undef strrchr
#endif

#ifdef REACTOS_COMPAT
#undef strspn
#define strspn captive_reactos_strspn
#else
#undef strspn
#endif

#ifdef REACTOS_COMPAT
#undef strstr
#define strstr captive_reactos_strstr
#else
#undef strstr
#endif

#ifdef REACTOS_COMPAT
#undef iswdigit
#define iswdigit captive_reactos_iswdigit
#else
#undef iswdigit
#endif

#ifdef REACTOS_COMPAT
#undef iswlower
#define iswlower captive_reactos_iswlower
#else
#undef iswlower
#endif

#ifdef REACTOS_COMPAT
#undef iswxdigit
#define iswxdigit captive_reactos_iswxdigit
#else
#undef iswxdigit
#endif

#ifdef REACTOS_COMPAT
#undef towlower
#define towlower captive_reactos_towlower
#else
#undef towlower
#endif

#ifdef REACTOS_COMPAT
#undef towupper
#define towupper captive_reactos_towupper
#else
#undef towupper
#endif

/* Place BEFORE "internal/debug.h" include as there is
 * 	internal/debug.h->internal/ntoskrnl.h->ddk/ntddk.h->REACTOS_UCS2()
 */
#ifdef REACTOS_COMPAT
#include <stddef.h>	/* for wchar_t; Prevent <stddef.h> declaration while REACTOS_COMPAT is active */
/* You MUST include "captive/unicode_reactos.h" before wchar_t redefinition! */
#include "captive/unicode_reactos.h"	/* for captive_ucs4_to_ucs2_const() for crtdll/string.h/REACTOS_UCS2() and captive_ucs2 */
#define wchar_t captive_ucs2
#define REACTOS_UCS2(string_wchar32) (captive_wchar32_to_ucs2_const((string_wchar32)))
#else
#undef wchar_t
#undef REACTOS_UCS2
#endif

/* for internal/debug.h */
#ifdef REACTOS_COMPAT
#define DBG 1
#else
#undef DBG
#endif

/* Defined platform as _WIN32 as it is checked by some reactos include files.
 * I expect it is set by MingW32 as I didn't find it defined anywhere in reactos distribution.
 */
#ifdef REACTOS_COMPAT
#define _WIN32 1
/* else _WIN64 1 */
#else
#undef _WIN32
#endif


/* reactos/ntos/security.h/'PACCESS_MODE' does not get defined if !__NT(OSKRNL|HAL)__
 */
#if _CAPTIVE_REACTOS_COMPAT_H == 1
#if !defined(__NTOSKRNL__) && !defined(__NTHAL__)
typedef /* ULONG: */ unsigned long ACCESS_MODE, *PACCESS_MODE;
#endif
#endif


/* -------------------------------- #include-s permitted now, #define-s forbidden
 * See above #define _CAPTIVE_REACTOS_COMPAT_H_INSIDE in this file.
 */


/* Define CAPTIVE_CDECL and CAPTIVE_STDCALL call types macros.
 * They do not need to be undefed as they are common to reactos and non-reactos code.
 * These macros have to be #ifdef-ed inside reactos itself.
 */
#ifdef REACTOS_COMPAT
#include "captive/calltype_reactos.h"	/* for CAPTIVE_CDECL and CAPTIVE_STDCALL */
#endif

/* Place AFTER REACTOS_UCS2 definition as there is
 * 	internal/debug.h->internal/ntoskrnl.h->ddk/ntddk.h->REACTOS_UCS2()
 * Some sources (reactos/ntoskrnl/ldr/loader.c) define NDEBUG themselves!
 * We have to pre-define all the non-NDEBUG (=debug) macros for such source files.
 */
#ifdef REACTOS_COMPAT
#ifdef __NTOSKRNL__	/* Don't pollute the namespace outside ntoskrnl. */
#include "reactos/internal/debug.h"
#endif
#endif

#ifdef REACTOS_COMPAT
/* All invalid reactos definitions go to captive_reactos_* as trash */
#define _KPCR            captive_reactos__KPCR
#define KPCR             captive_reactos_KPCR
#define PKPCR            captive_reactos_PKPCR
#define _IKPCR           captive_reactos__IKPCR
#define IKPCR            captive_reactos_IKPCR
#define PIKPCR           captive_reactos_PIKPCR
#define KeGetCurrentKPCR captive_reactos_KeGetCurrentKPCR
#include "reactos/internal/i386/ps.h"
#undef _KPCR
#undef KPCR
#undef PKPCR
#undef _IKPCR
#undef IKPCR
#undef PIKPCR
#undef KeGetCurrentKPCR
/* Usable libcaptive definition for reactos go to captive_*.
 * Note we don't leave any defintion under its original symbol name
 * just to make the whole mess a bit more sane.
 */
#include "captive/ps_reactos.h"
#define _KPCR            captive__KPCR
#define KPCR             captive_KPCR
#define PKPCR            captive_PKPCR
#define _IKPCR           captive__KPCR
#define IKPCR            captive_KPCR
#define PIKPCR           captive_PKPCR
#define KeGetCurrentKPCR captive_KeGetCurrentKPCR
#else
#undef _KPCR
#undef KPCR
#undef PKPCR
#undef _IKPCR
#undef IKPCR
#undef PIKPCR
#undef KeGetCurrentKPCR
#endif


#undef _CAPTIVE_REACTOS_COMPAT_H_INSIDE
