/* $Id: create.c,v 1.2 2003/03/25 03:00:10 short Exp $
 * reactos I/O streams management of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/iofuncs.h"	/* self */
#include <glib/gmessages.h>
#include <glib/ghash.h>


/* map: (FILE_OBJECT *) -> GINT_TO_POINTER(1) */
static GHashTable *captive_stream_file_object_hash;

/* initialize 'captive_stream_file_object_hash' */
static void captive_stream_file_object_hash_init(void)
{
	if (captive_stream_file_object_hash)
		return;
	captive_stream_file_object_hash=g_hash_table_new(g_direct_hash,g_direct_equal);
}


BOOLEAN IoCreateStreamFileObjectLite_is_owner(FILE_OBJECT *FileObject)
{
	g_return_val_if_fail(FileObject!=NULL,FALSE);

	captive_stream_file_object_hash_init();

	return !!g_hash_table_lookup(captive_stream_file_object_hash,FileObject);
}


void IoCreateStreamFileObjectLite_remove(FILE_OBJECT *FileObject)
{
gboolean errbool;

	g_return_if_fail(FileObject!=NULL);

	captive_stream_file_object_hash_init();

	errbool=g_hash_table_remove(captive_stream_file_object_hash,FileObject);
	g_assert(errbool==TRUE);
}


PFILE_OBJECT IoCreateStreamFileObjectLite(IN PFILE_OBJECT FileObject OPTIONAL,IN PDEVICE_OBJECT DeviceObject OPTIONAL)
{
FILE_OBJECT *r;

	captive_stream_file_object_hash_init();

	r=IoCreateStreamFileObject(FileObject,DeviceObject);
	g_return_val_if_fail(r!=NULL,NULL);

	g_assert(NULL==g_hash_table_lookup(captive_stream_file_object_hash,r));	/* paranoia sanity */

	g_hash_table_insert(captive_stream_file_object_hash,r,GINT_TO_POINTER(1));

	return r;
}
