/* $Id: device.c,v 1.1 2003/03/24 00:10:30 short Exp $
 * reactos devices management of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/iofuncs.h"	/* self */
#include <glib/gmessages.h>


/* Driver in fs module loaded by captive_w32_init().
 * Located in: libcaptive/client/init.c
 */
extern DRIVER_OBJECT captive_DriverObject;
extern PDRIVER_REINITIALIZE captive_DriverObject_ReinitRoutine;
extern PVOID captive_DriverObject_ReinitRoutine_Context;


/**
 * IoRegisterDriverReinitialization:
 * @DriverObject: #DRIVER_OBJECT of the driver registering @ReinitRoutine.
 * Exact unique #captive_DriverObject structure address required by libcaptive.
 * @ReinitRoutine: Function to be later called back.
 * %NULL value is forbidden.
 * @Context: Arbitrary argument of @ReinitRoutine to be passed along.
 * %NULL value is permitted.
 *
 * Register function to be called after the current initialization
 * route of the filesystem returned.
 *
 * Initialization routine may call this function at most once.
 * The callbacked @ReinitRoutine is allowed to call this function again
 * ad infinitum.
 */
VOID IoRegisterDriverReinitialization(PDRIVER_OBJECT DriverObject,PDRIVER_REINITIALIZE ReinitRoutine,PVOID Context)
{
	g_return_if_fail(DriverObject!=NULL);
	g_return_if_fail(ReinitRoutine!=NULL);

	/* libcaptive supports exactly one filesystem driver */
	g_return_if_fail(DriverObject==&captive_DriverObject);

	/* This function may be called at most once. */
	g_return_if_fail(captive_DriverObject_ReinitRoutine==NULL);

	captive_DriverObject_ReinitRoutine=ReinitRoutine;
	captive_DriverObject_ReinitRoutine_Context=Context;
}
