/* $Id: irp.c,v 1.2 2003/09/15 18:02:31 short Exp $
 * reactos spinlock emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/iotypes.h"	/* for PIRP */
#include <glib/gmessages.h>
#include <glib/gmem.h>
#include "captive/macros.h"
#include <glib/gmain.h>
#include "reactos/internal/io.h"	/* for IoSecondStageCompletion() */


struct IofCompleteRequest_register_APC {
		PFILE_OBJECT OriginalFileObject;
		IRP *Irp;
		CHAR PriorityBoost;
		};

static gboolean IofCompleteRequest_register_APC_idle_func(struct IofCompleteRequest_register_APC *APC /*data*/)
{
	g_return_val_if_fail(APC!=NULL,FALSE);	/* remove-me */

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"%s: IoSecondStageCompletion(IRP=%p)...",G_STRLOC,APC->Irp);
	IoSecondStageCompletion(NULL,NULL,(PVOID)&APC->OriginalFileObject,(PVOID)&APC->Irp,(PVOID)&APC->PriorityBoost);
	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"%s: ...IoSecondStageCompletion(IRP=%p) done",G_STRLOC,APC->Irp);

	g_free(APC);

	return FALSE;	/* remove-me */
}


void IofCompleteRequest_register_APC(PFILE_OBJECT OriginalFileObject,PIRP Irp,CCHAR PriorityBoost)
{
struct IofCompleteRequest_register_APC *APC;

	g_return_if_fail(Irp!=NULL);

	captive_new(APC);
	APC->OriginalFileObject=OriginalFileObject;
	APC->Irp=Irp;
	APC->PriorityBoost=PriorityBoost;

	g_idle_add_full(
			G_PRIORITY_DEFAULT_IDLE,	/* priority */
			(GSourceFunc)IofCompleteRequest_register_APC_idle_func,	/* function */
			APC,	/* data */
			NULL);	/* notify */
}
