/* $Id: process.c,v 1.2 2003/10/05 20:26:09 short Exp $
 * reactos spinlock emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/iofuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ddk/psfuncs.h"	/* for PsGetCurrentThread() */


/**
 * IoGetStackLimits:
 * @LowLimit: Returns the bottom limit for the current stack pointer.
 * @HighLimit: Returns the top limit for the current stack pointer.
 *
 * Returns the boundaries for the current stack pointer (address space
 * of automatic variables). libcaptive returns the whole UNIX process
 * address space without some safety boundary space (64KB now).
 */
VOID IoGetStackLimits(OUT PULONG LowLimit,OUT PULONG HighLimit)
{
	g_return_if_fail(LowLimit!=NULL);
	g_return_if_fail(HighLimit!=NULL);

	*LowLimit =(ULONG) 0x10000;	/* 64KB */
	*HighLimit=(ULONG)-0x10000;	/* 64KB */
}


/**
 * IoIsSystemThread:
 * @Thread: #PETHREAD of the thread to query.
 * libcaptive allows only PsGetCurrentThread() value.
 *
 * Detect if the given @Thread is a kernel system thread.
 * FIXME: Not much specific...
 *
 * Returns: %TRUE if the given @Thread is a kernel system thread.
 * libcaptive always returns %TRUE.
 */
BOOLEAN IoIsSystemThread(IN PETHREAD Thread)
{
	g_return_val_if_fail(Thread==PsGetCurrentThread(),FALSE);

	return TRUE;
}
