/* $Id: symlink.c,v 1.2 2003/11/10 21:16:19 short Exp $
 * reactos spinlock emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/iofuncs.h"	/* self */
#include <glib/gmessages.h>
#include "captive/unicode.h"


/**
 * IoCreateSymbolicLink:
 * @SymbolicLinkName: Target registry key name.
 * @DeviceName: Existing source registry key.
 *
 * Creates registry symbolic name from @DeviceName to @SymbolicLinkName.
 * It is being used for example for dos-device-name filesystem aliases.
 *
 * Returns: libcaptive always returns error %STATUS_NOT_IMPLEMENTED.
 */
NTSTATUS IoCreateSymbolicLink(PUNICODE_STRING SymbolicLinkName,PUNICODE_STRING DeviceName)
{
	g_return_val_if_fail(SymbolicLinkName!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(DeviceName!=NULL,STATUS_INVALID_PARAMETER);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"%s: SymbolicLinkName=%s,DeviceName=%s",G_STRLOC,
			captive_UnicodeString_to_utf8_alloca(SymbolicLinkName),
			captive_UnicodeString_to_utf8_alloca(DeviceName));

	if (!strcmp(captive_UnicodeString_to_utf8_alloca(SymbolicLinkName),"\\DosDevices\\AscKmd")
			&& !strcmp(captive_UnicodeString_to_utf8_alloca(DeviceName),"\\Device\\AscKmd"))
		return STATUS_SUCCESS;
	if (!strcmp(captive_UnicodeString_to_utf8_alloca(SymbolicLinkName),"\\DosDevices\\Secdrv")
			&& !strcmp(captive_UnicodeString_to_utf8_alloca(DeviceName),"\\Device\\Secdrv"))
		return STATUS_SUCCESS;

	return STATUS_NOT_IMPLEMENTED;
}
