/* $Id: kdebug.c,v 1.1 2002/10/31 17:37:52 short Exp $
 * reactos spinlock emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/internal/kd.h"	/* self */
#include "captive/unicode.h"	/* for captive_validate_AnsiString() */
#include <glib/gtypes.h>
#include <glib/gmessages.h>
#include <glib/galloca.h>
#include <glib/gstring.h>
#include <glib/gmem.h>


/**
 * KdDebuggerEnabled:
 *
 * #BOOLEAN variable defined to %FALSE by libcaptive.
 * Currently just enables some debug output in
 * reactos/ntoskrnl/ldr/loader.c
 */
BOOLEAN /* __declspec(dllexport) */ KdDebuggerEnabled=FALSE;

/**
 * KdDebugState:
 *
 * Defined to %KD_DEBUG_DISABLED by default in reactos.
 * Currently just enables some debug output in
 * reactos/ntoskrnl/ldr/loader.c
 */
ULONG KdDebugState=KD_DEBUG_GDB;


/* storage for the trailing string part without newline */
static GString *KdpPrintString_buffer;

/**
 * KdpPrintString:
 * @String: String text to print. Buffer is flushed only when newline seen.
 *
 * Prints the specified text string to the console. libcaptive
 * accepts any newline characters as valid and autonewlines the text
 * if needed.
 */
ULONG KdpPrintString(PANSI_STRING String)
{
gchar *out_base,*out;
const CHAR *in;

	g_return_val_if_fail(captive_validate_AnsiString(String),0);

	out_base=g_alloca(((size_t)String->Length)+1);
	out=out_base;
	for (in=String->Buffer;*in;in++) {
		if (*in=='\r' && in[1]=='\n')
			in++;
		if (*in=='\r' || *in=='\n')
			*out++='\n';
		else
			*out++=*in;
		}
	*out='\0';
	
	/* Print all completed lines */
	if ((out=strrchr(out_base,'\n'))) {
gchar *previous;

		*out='\0';	/* cut off the rest of string */

		if (!KdpPrintString_buffer)
			previous=NULL;
		else {
			previous=g_string_free(KdpPrintString_buffer,
					FALSE);  /* free_segment */
			KdpPrintString_buffer=NULL;
			}
		g_message("KdpPrintString: %s%s",	/* newline is appended by g_message() */
				(!previous ? "" : previous),
				out_base);
		if (previous)
			g_free(previous);

		out_base=out+1;	/* leave the rest of string (if any) */
		}

	/* store/append the remaining rest of string w/o newline */
	if (*out_base)
		KdpPrintString_buffer=(!KdpPrintString_buffer ? g_string_new(out_base)
				: g_string_append(KdpPrintString_buffer,out_base));

	return (ULONG)String->Length;
}
