/* $Id: bug.c,v 1.3 2003/02/13 09:49:50 short Exp $
 * reactos internal errors handling by the emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include <glib/gmessages.h>


/**
 * KeBugCheck:
 * @BugCheckCode: Error code to report.
 *
 * Report fatal kernel bug. This call never returns.
 */
VOID KeBugCheck(ULONG BugCheckCode)
{
	/* FIXME: Search for BugCheckCode's message text
	 *  by in RT_MESSAGETABLE as done by reactos/ntoskrnl/ke/bug.c/KeBugCheckEx()
	 */
	g_error("KeBugCheck: 0x%08lX",(gulong)BugCheckCode);
	g_assert_not_reached();
}
