/* $Id: event.c,v 1.7 2002/11/22 13:25:59 short Exp $
 * reactos events emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ddk/exfuncs.h"	/* for InterlockedExchange() */


/**
 * KeInitializeEvent:
 * @Event: Event to initialize.
 * %NULL value is forbidden.
 * @Type: %NotificationEvent or %SynchronizationEvent.
 * @State: Initial signal state.
 *
 * Initalizes a kernel event. Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now.
 */
VOID KeInitializeEvent(PKEVENT Event,EVENT_TYPE Type,BOOLEAN State)
{
	g_return_if_fail(Event!=NULL);
	g_return_if_fail(Type==NotificationEvent || Type==SynchronizationEvent);

	/* TODO:thread */
}


/**
 * KeSetEvent:
 * @Event: Event to set its signal state on.
 * %NULL value is forbidden.
 * @Increment: Thread priority increase during wait; ignored by libcaptive.
 * @Wait: Do not release locks, KeWait() is required afterwards; ignored by libcaptive.
 *
 * Sets the signal state of @Event. Currently libcaptive doesn't use multithreading
 * and thus this function will just set the @Event's internal state and it returns
 * the previous value.
 * See also KeResetEvent(), KeClearEvent().
 *
 * Returns: Previous signal state value of @Event.
 */
LONG KeSetEvent(PKEVENT Event,KPRIORITY Increment,BOOLEAN Wait)
{
	g_return_val_if_fail(Event!=NULL,0);

	/* TODO:thread */
	return InterlockedExchange(&(Event->Header.SignalState),1);
}


/**
 * KeResetEvent:
 * @Event: Event to clear its signal state off.
 * %NULL value is forbidden.
 *
 * Clears the signal state of @Event. See also KeSetEvent().
 * Use KeClearEvent() if you do not need the previous signal state of @Event.
 *
 * Returns: Previous signal state value of @Event.
 */
LONG KeResetEvent(PKEVENT Event)
{
	g_return_val_if_fail(Event!=NULL,0);

	return InterlockedExchange(&(Event->Header.SignalState),0);
}


/**
 * KeClearEvent:
 * @Event: Event to clear its signal state off.
 * %NULL value is forbidden.
 *
 * Clears the signal state of @Event. See also KeSetEvent().
 * Use KeResetEvent() if you need the previous signal state of @Event.
 */
VOID KeClearEvent(PKEVENT Event)
{
	g_return_if_fail(Event!=NULL);

	Event->Header.SignalState=FALSE;
}
