/* $Id: sem.c,v 1.3 2002/11/02 23:44:40 short Exp $
 * reactos semaphore emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include <glib/gmessages.h>


/**
 * KeInitializeSemaphore:
 * @Semaphore: Memory to initialize as #KSEMAPHORE.
 * @Count: Initial semaphore signal state.
 * @Limit: Maximum semaphore signal state.
 *
 * Initalizes a semaphore. Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now.
 */
VOID KeInitializeSemaphore(PKSEMAPHORE Semaphore,LONG Count,LONG Limit)
{
	g_return_if_fail(Semaphore!=NULL);
	g_return_if_fail(Count>=0);
	g_return_if_fail(Limit>=0);
	g_return_if_fail(Count<=Limit);

	/* TODO:thread */
	Semaphore->Limit=Limit;
}
