/* $Id: timer.c,v 1.4 2003/12/06 19:00:25 short Exp $
 * reactos time handling functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include <glib/gmessages.h>
#include <sys/time.h>


/* This file is based on 'wine/dlls/ntdll/time.c' */


/* 1601 to 1970 is 369 years plus 89 leap days */
#define SECS_1601_TO_1970 ((369*365+89)*G_GINT64_CONSTANT(86400))


/**
 * KeQuerySystemTime:
 * @CurrentTime: Returns the current time.
 * %NULL pointer value is forbidden.
 *
 * Returns the number of passed 100ns (1e-7) intervals from 1 Jan 1601.
 */
VOID KeQuerySystemTime(PLARGE_INTEGER CurrentTime)
{
struct timeval tv;
int errint;

	g_return_if_fail(CurrentTime!=NULL);

	errint=gettimeofday(
			&tv,	/* tv; timeval */
			NULL);	/* tz; timezone */
	g_assert(errint==0);

	CurrentTime->QuadPart=(tv.tv_sec+SECS_1601_TO_1970)*G_GINT64_CONSTANT(10000000)+tv.tv_usec*10;
}


/**
 * KeSetTimer:
 * @Timer: Previously initialized timer object.
 * %NULL value is forbidden.
 * @DueTime: If positive then absolute time to expire at.
 * If negative then the relative time to expire at.
 * @Dpc: If non %NULL then a #KDPC to be called when the timer expires.
 *
 * Sets the absolute or relative interval at which a timer object
 * is to be set to the signaled state and optionally supplies a
 * CustomTimerDpc to be executed when the timer expires.
 *
 * libcaptive does not support such timers and this function is a NOP there.
 *
 * Returns: %TRUE if the timer was already in the system timer queue.
 * libcaptive always returns %FALSE.
 */
BOOLEAN KeSetTimer(PKTIMER Timer,LARGE_INTEGER DueTime,PKDPC Dpc)
{
	g_return_val_if_fail(Timer!=NULL,TRUE);

	/* NOP */

	return FALSE;	/* Timer was not yet in the system queue. */
}


/**
 * KeCancelTimer:
 * @Timer: Timer to cancel.
 * %NULL value is forbidden.
 *
 * Removes a timer from the system timer list.
 *
 * libcaptive does not support such timers and this function is a NOP there.
 *
 * Returns: %TRUE if the timer was running.
 * libcaptive always returns %FALSE.
 */
BOOLEAN KeCancelTimer(PKTIMER Timer)
{
	g_return_val_if_fail(Timer!=NULL,TRUE);

	/* NOP */

	return FALSE;	/* Timer was not running. */
}


/**
 * KeInitializeTimer:
 * @Timer: Caller supplied storage for the timer.
 *
 * Initalizes a kernel timer object.
 *
 * libcaptive does not support such timers and this function is a NOP there.
 */
VOID KeInitializeTimer(PKTIMER Timer)
{
	g_return_if_fail(Timer!=NULL);

	/* NOP */
}


/**
 * KeDelayExecutionThread:
 * @WaitMode: Processor mode in which the caller is waiting.
 * libcaptive requires %KernelMode value.
 * @Altertable: Specifies if the wait is alertable.
 * libcaptive requires %FALSE value.
 * @Interval: Specifies the interval to wait.
 * Pointer %NULL is forbidden.
 * libcaptive ignores the value.
 *
 * Function puts the current thread into an alertable or nonalertable wait
 * state for a given internal. libcaptive never waits.
 *
 * Returns: libcaptive returns %STATUS_SUCCESS (interval passed).
 */
NTSTATUS KeDelayExecutionThread(KPROCESSOR_MODE WaitMode,BOOLEAN Alertable,PLARGE_INTEGER Interval)
{
	g_return_val_if_fail(WaitMode==KernelMode,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Alertable==FALSE,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Interval!=NULL,STATUS_INVALID_PARAMETER);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"%s: Interval=%lld, returning STATUS_SUCCESS",G_STRLOC,
			(long long)Interval->QuadPart);

	return STATUS_SUCCESS;
}
