/* $Id: wait.c,v 1.2 2003/03/24 21:11:18 short Exp $
 * reactos object wait emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include "reactos/ddk/status.h"	/* for STATUS_SUCCESS */
#include "reactos/napi/types.h"	/* for NTSTATUS */
#include <glib/gmessages.h>
#include <glib/gmain.h>


/**
 * KeWaitForSingleObject:
 * @Object: Ignored. %NULL value is forbidden.
 * @WaitReason: Ignored.
 * @WaitMode: Ignored.
 * @Alertable: Ignored.
 * @Timeout: Ignored.
 *
 * Puts the current thread into a wait state until the
 * given dispatcher @Object is set to signalled.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now.
 *
 * Returns: %STATUS_SUCCESS.
 */
NTSTATUS KeWaitForSingleObject
		(PVOID Object,KWAIT_REASON WaitReason,KPROCESSOR_MODE WaitMode,BOOLEAN Alertable,PLARGE_INTEGER Timeout)
{
	g_return_val_if_fail(Object!=NULL,STATUS_INVALID_PARAMETER);

	/* ntfs.sys during IopMountFilesystem() will return STATUS_PENDING
	 * and it expects its ExQueueWorkItem() to be processed before evaluating
	 * the result of its driver call.
	 */
	while (g_main_context_iteration(
			NULL,	/* context; NULL means default one */
			FALSE))	/* may_block */
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"%s: g_main_context_iteration() proceeded",G_STRLOC);


	/* TODO:thread */
	return STATUS_SUCCESS;
}
