/* $Id: marea.c,v 1.2 2003/09/15 18:02:31 short Exp $
 * reactos MemoryArea emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/internal/mm.h"	/* self */
#include <glib/gmessages.h>
#include <glib/gmem.h>
#include "captive/macros.h"


/**
 * MmCreateMemoryArea:
 * @Process: #PEPROCESS owning the memory being allocated. Ignored by libcaptive.
 * %NULL value is forbidden.
 * @AddressSpace: #PMADDRESS_SPACE where to place the allocation. Ignored by libcaptive.
 * %NULL value is forbidden.
 * @Type: Unknown. Ignored by libcaptive (copied to target @Result).
 * @BaseAddress: Requests/returns required/allocated memory fixed address.
 * FIXME: Pointed value required %NULL by libcaptive.
 * %NULL pointer is forbidden.
 * @Length: Allocation length. %PAGE_SIZE round up by libcaptive (FIXME: needed?).
 * @Attributes: Unknown. Ignored by libcaptive (copied to target @Result).
 * @Result: Returns new allocated #MEMORY_AREA. Previous pointed value lost.
 * %NULL pointer is forbidden.
 * @FixedAddress: Whether @BaseAddress points to the required address.
 * FIXME: %FALSE required by libcaptive.
 * @TopDown: %TRUE if we should search the area from the top of memory address space.
 * Ignored by libcaptive.
 *
 * Reserves the memory of size @Length from @AddressSpace.
 * FIXME: libcaptive currently does not enqueue this allocation to @AddressSpace.
 *
 * libcaptive currently automatically fills the reserved memory space with a real
 * read/write non-executable memory pages allocated by MmAllocateSection().
 * It is currently being (mis)used by ntoskrnl/cc/view.c/CcRosCreateCacheSegment().
 * This preallocation should not hurt as our memory just may get overriden
 * by another one.
 *
 * Returns: %STATUS_SUCCESS if the allocation was successful.
 * @Result will contain a new #MEMORY_AREA in such case.
 */
NTSTATUS MmCreateMemoryArea(PEPROCESS Process,PMADDRESS_SPACE AddressSpace,
		ULONG Type,PVOID* BaseAddress,ULONG Length,ULONG Attributes,MEMORY_AREA** Result,BOOL FixedAddress,BOOL TopDown)
{
MEMORY_AREA *marea;

	g_return_val_if_fail(Process!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(AddressSpace!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(BaseAddress!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Length>0,STATUS_INVALID_PARAMETER);

	/* FIXME: Fixed allocations not implemented yet */
	g_assert(*BaseAddress==NULL && !FixedAddress);

	/* round-up - is it needed? */
	Length=(Length|(PAGE_SIZE-1))+1;

	/* We allocate the memory although it is not expected from such W32 call */
	*BaseAddress=MmAllocateSection(Length);
	g_assert(*BaseAddress!=NULL);

	/* FIXME: Why is reactos doring '(*BaseAddress)+=PAGE_SIZE'
	 * in ntoskrnl/mm/marea.c/MmCreateMemoryArea() ?
	 */

	captive_new0(*Result);
	marea=*Result;
	marea->Type=Type;
	marea->BaseAddress=*BaseAddress;
	marea->Length=Length;
	marea->Attributes=Attributes;
	marea->LockCount=0;
	marea->Process=Process;
	marea->PageOpCount=0;
	marea->DeleteInProgress=FALSE;

	return STATUS_SUCCESS;
}
