/* $Id: memsafe.c,v 1.3 2003/09/15 18:02:31 short Exp $
 * reactos memory user/kernel memory handling functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/internal/mm.h"	/* self */
#include <glib/gmessages.h>
#include <string.h>


/**
 * MmSafeCopyFromUser:
 * @Dest: Destination memory area address.
 * %NULL value is forbidden.
 * @Src: Source memory area address.
 * %NULL value is forbidden.
 * @NumberOfBytes: Length of memory area.
 *
 * This function moves the data between two memory areas.
 * Given memory areas must not overlap.
 * libcaptive does not differentiate between user and kernel memory - this functions
 * implements the simple memcpy() function.
 * 
 * Returns: %STATUS_SUCCESS if the memory was copied successfuly.
 */
NTSTATUS MmSafeCopyFromUser(PVOID Dest,const VOID *Src,ULONG NumberOfBytes)
{
	g_return_val_if_fail(Dest!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Dest+NumberOfBytes>=Dest,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Src!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Src+NumberOfBytes>=Src,STATUS_INVALID_PARAMETER);
	/* do not overlap: */
	g_return_val_if_fail((Dest+NumberOfBytes<=Src || Dest>=Src+NumberOfBytes),STATUS_INVALID_PARAMETER);

	memcpy(Dest,Src,NumberOfBytes);

	return STATUS_SUCCESS;
}


/**
 * MmSafeCopyToUser:
 * @Dest: Destination memory area address.
 * %NULL value is forbidden.
 * @Src: Source memory area address.
 * %NULL value is forbidden.
 * @NumberOfBytes: Length of memory area.
 *
 * This function moves the data between two memory areas.
 * Given memory areas must not overlap.
 * libcaptive does not differentiate between user and kernel memory - this functions
 * implements the simple memcpy() function.
 * 
 * Returns: %STATUS_SUCCESS if the memory was copied successfuly.
 */
NTSTATUS MmSafeCopyToUser(PVOID Dest,const VOID *Src,ULONG NumberOfBytes)
{
	g_return_val_if_fail(Dest!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Dest+NumberOfBytes>=Dest,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Src!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Src+NumberOfBytes>=Src,STATUS_INVALID_PARAMETER);
	/* do not overlap: */
	g_return_val_if_fail((Dest+NumberOfBytes<=Src || Dest>=Src+NumberOfBytes),STATUS_INVALID_PARAMETER);

	memcpy(Dest,Src,NumberOfBytes);

	return STATUS_SUCCESS;
}
