/* $Id: section.c,v 1.5 2003/04/08 17:59:48 short Exp $
 * reactos memory areas emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/mm.h"	/* self, for captive_flProtect_to_mmap_prot() */
#include "reactos/internal/mm.h"	/* self */
#include "reactos/ntos/types.h"	/* for PVOID etc. */
#include <glib/gmessages.h>
#include <sys/mman.h>	/* for PROT_NONE etc. */


/**
 * MmAllocateSection:
 * @Length: Length (in bytes) of the area to allocate. Does not have to be page
 * aligned. Value 0 is forbidden.
 *
 * Allocates @Length area with %PAGE_READWRITE flags.
 *
 * Returns: Allocated address space if the allocation was successful.
 */
PVOID MmAllocateSection(IN ULONG Length)
{
int mmap_prot=captive_flProtect_to_mmap_prot(PAGE_READWRITE);
PVOID r;

	g_return_val_if_fail(Length>0,NULL);

	Length=(Length|(PAGE_SIZE-1))+1;	/* round up to PAGE_SIZE */

	r=mmap(
			NULL,	/* start */
			Length,	/* length */
			mmap_prot,	/* prot */
			MAP_PRIVATE|MAP_ANONYMOUS,	/* flags */
			-1,	/* fd; ignored due to MAP_ANONYMOUS */
			0);	/* offset; ignored due to MAP_ANONYMOUS */
	g_return_val_if_fail(r!=NULL,NULL);

	captive_mmap_map_new(r,Length,mmap_prot);

	/* assumed r!=NULL */
	return r;
}


/**
 * MmFlushImageSection:
 * @SectionObjectPointer: Section to flush description.
 * %NULL value is forbidden.
 * @FlushType: %MmFlushForDelete or %MmFlushForWrite.
 *
 * Function flushes any cached #ImageSectionObject.
 * libcaptive does not cache any images and therefore this function is a NOP there.
 *
 * Returns: %TRUE if the operation was successful.
 */
BOOLEAN MmFlushImageSection(IN PSECTION_OBJECT_POINTERS SectionObjectPointer,IN MMFLUSH_TYPE FlushType)
{
	g_return_val_if_fail(SectionObjectPointer!=NULL,FALSE);
	g_return_val_if_fail(FlushType==MmFlushForDelete || FlushType==MmFlushForWrite,FALSE);

	g_return_val_if_fail(SectionObjectPointer->ImageSectionObject==NULL,FALSE);	/* NOT IMPLEMENTED YET */

  return TRUE;	/* No section mapped or it was successfuly flushed. */
}


BOOLEAN MmCanFileBeTruncated(IN PSECTION_OBJECT_POINTERS SectionObjectPointer,IN PLARGE_INTEGER NewFileSize)
{
	g_return_val_if_fail(SectionObjectPointer!=NULL,FALSE);	/* means do not allow truncation */
	/* 'NewFileSize' may by NULL
	 * Passed as NULL by ntfs.sys of NT-5.1sp1; FIXME: What does it mean?
	 */

	g_assert(!NewFileSize || NewFileSize->QuadPart>=0);

	return TRUE;	/* allowed */
}
