/* $Id: ntevent.c,v 1.1 2003/03/24 02:24:58 short Exp $
 * reactos support for event handling for reactos of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ntos/zw.h"	/* self */
#include <glib/gmessages.h>


/**
 * ZwCreateEvent:
 * @EventHandle: Returns new created #HANDLE.
 * %NULL value is forbidden.
 * @DesiredAccess: Required access privileges to the created event handle.
 * @ObjectAttributes: Event object attributes by InitializeObjectAttributes().
 * %NULL value is forbidden.
 * @ManualReset: Use %NotificationEvent instead of %SynchronizationEvent.
 * @InitialState: initial state of the created @EventHandle.
 *
 * Direct pass to NtCreateEvent(). reactos aliases this call to NtCreateEvent()
 * in its "reactos/iface/native/sysfuncs.lst" file.
 *
 * Returns: Return status code from NtCreateEvent().
 */
NTSTATUS ZwCreateEvent(OUT PHANDLE EventHandle,
		IN ACCESS_MASK DesiredAccess,IN POBJECT_ATTRIBUTES ObjectAttributes,IN BOOLEAN ManualReset,IN BOOLEAN InitialState)
{
	g_return_val_if_fail(EventHandle!=NULL,STATUS_INVALID_HANDLE);
	g_return_val_if_fail(ObjectAttributes!=NULL,STATUS_INVALID_HANDLE);

	return NtCreateEvent(EventHandle,DesiredAccess,ObjectAttributes,ManualReset,InitialState);
}
