/* $Id: dirobj.c,v 1.2 2003/02/13 09:52:39 short Exp $
 * reactos support for object directories handling for reactos of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ntos/zw.h"	/* self */
#include "reactos/ntos/types.h"	/* for PHANDLE */
#include "reactos/napi/types.h"	/* for NTSTATUS */
#include <glib/gmessages.h>


/**
 * ZwCreateDirectoryObject:
 * @DirectoryHandle: Returns pointer to the created directory object handle.
 * %NULL value is forbidden.
 * @DesiredAccess: Required access privileges to the created directory object handle.
 * @ObjectAttributes: Directory object attributes by InitializeObjectAttributes().
 * %NULL value is forbidden.
 *
 * Direct pass to NtCreateDirectoryObject(). reactos aliases this call to NtCreateDirectoryObject()
 * in its "reactos/iface/native/sysfuncs.lst" file.
 *
 * Returns: Return status code from NtCreateDirectoryObject().
 */
NTSTATUS ZwCreateDirectoryObject
		(OUT PHANDLE DirectoryHandle,IN ACCESS_MASK DesiredAccess,IN POBJECT_ATTRIBUTES ObjectAttributes)
{
	g_return_val_if_fail(DirectoryHandle!=NULL,STATUS_INVALID_HANDLE);
	g_return_val_if_fail(ObjectAttributes!=NULL,STATUS_INVALID_HANDLE);

	return NtCreateDirectoryObject(DirectoryHandle,DesiredAccess,ObjectAttributes);
}
