/* $Id: handle.c,v 1.4 2003/03/24 02:25:44 short Exp $
 * reactos support for object handle handling for reactos of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ntos/zw.h"	/* self */
#include "reactos/ntos/types.h"	/* for HANDLE */
#include "reactos/napi/types.h"	/* for NTSTATUS */
#include <glib/gmessages.h>


/* libcaptive/ps/create.c: */
extern const guint8 PsCreateSystemThread_bogusthread;


/**
 * ZwClose:
 * @Handle: Handle from some Zw*() create function.
 * %NULL value is forbidden.
 *
 * Direct pass to NtClose(). reactos aliases this call to NtClose()
 * in its "reactos/iface/native/sysfuncs.lst" file.
 *
 * Returns: Return status code from NtClose().
 */
NTSTATUS ZwClose(HANDLE Handle)
{
	g_return_val_if_fail(Handle!=NULL,STATUS_INVALID_HANDLE);

	/* FIXME: libcaptive does not yet create the threads (thread objects)
	 * but ntfs.sys will ZwClose() immediately after its PsCreateSystemThread().
	 */
	if (Handle==(HANDLE)&PsCreateSystemThread_bogusthread)
		return STATUS_SUCCESS;

	return NtClose(Handle);
}
