/* $Id: shutdownwork.c,v 1.4 2003/09/23 07:08:58 short Exp $
 * reactos PoQueueShutdownWorkItem() implementation by libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

/* no reactos prototype for PoQueueShutdownWorkItem() */
#include "captive/ldr.h"	/* self; for captive_PoQueueShutdownWorkItem_hooklist_invoke() */
#include <glib/gmessages.h>
#include <glib/ghook.h>
#include "reactos/ddk/extypes.h"	/* for WORK_QUEUE_ITEM */
#include "captive/macros.h"


static GHookList captive_PoQueueShutdownWorkItem_hooklist;


static void captive_PoQueueShutdownWorkItem_hooklist_init(void)
{
	if (captive_PoQueueShutdownWorkItem_hooklist.is_setup)
		return;

	g_hook_list_init(&captive_PoQueueShutdownWorkItem_hooklist,sizeof(GHook));
}


void captive_PoQueueShutdownWorkItem_hooklist_invoke(void)
{
	captive_PoQueueShutdownWorkItem_hooklist_init();

	g_hook_list_invoke(&captive_PoQueueShutdownWorkItem_hooklist,
			FALSE);	/* may_recurse */
	g_hook_list_clear(&captive_PoQueueShutdownWorkItem_hooklist);
}


struct captive_work_queue_item {
	PWORKER_THREAD_ROUTINE WorkerRoutine;
	PVOID Parameter;
	};

static void PoQueueShutdownWorkItem_func(struct captive_work_queue_item *captive_work_queue_item /* data */)
{
	g_return_if_fail(captive_work_queue_item!=NULL);

	/* typedef VOID CAPTIVE_STDCALL (*PWORKER_THREAD_ROUTINE)(IN PVOID Context); */

	captive_stdcall_call_4((CaptiveStdCallFunc4)captive_work_queue_item->WorkerRoutine,
			captive_work_queue_item->Parameter);	/* Context */

	g_free(captive_work_queue_item);
}

NTSTATUS PoQueueShutdownWorkItem(IN PWORK_QUEUE_ITEM WorkItem)
{
GHook *ghook;
struct captive_work_queue_item *captive_work_queue_item;

	g_return_val_if_fail(WorkItem!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(WorkItem->WorkerRoutine!=NULL,STATUS_INVALID_PARAMETER);

	captive_PoQueueShutdownWorkItem_hooklist_init();

	captive_new(captive_work_queue_item);
	captive_work_queue_item->WorkerRoutine=WorkItem->WorkerRoutine;
	captive_work_queue_item->Parameter=WorkItem->Parameter;

	/* FIXME: Should we check for func/data dupes? Are they permitted by W32? */

	ghook=g_hook_alloc(&captive_PoQueueShutdownWorkItem_hooklist);
	ghook->func=PoQueueShutdownWorkItem_func;
	ghook->data=captive_work_queue_item;
	g_hook_append(&captive_PoQueueShutdownWorkItem_hooklist,ghook);

	return STATUS_SUCCESS;
}
