/* $Id: create.c,v 1.1 2003/03/24 02:26:53 short Exp $
 * reactos thread creation emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/psfuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ddk/status.h"


const guint8 PsCreateSystemThread_bogusthread;

/**
 * PsCreateSystemThread:
 * @ThreadHandle: Returns the new thread handle.
 * %NULL value is forbidden.
 * @DesiredAccess: Requested access to the thread.
 * @ObjectAttributes: Object attributes.
 * %NULL value is permitted.
 * @ProcessHandle: Handle of process thread will run in.
 * Use %NULL to specify system process.
 * @ClientId: Returns the new client id of the thread.
 * %NULL value is permitted.
 * @StartRoutine = Entry point for the new thread.
 * %NULL value is forbidden.
 * @StartContext = Argument supplied to the thread when it begins execution.
 * %NULL value is permitted.
 *
 * Creates a new thread.
 * FIXME: libcaptive does not create any thread, it is a NOP function there.
 *
 * Returns: %STATUS_SUCCESS if the operation was successful.
 */
NTSTATUS PsCreateSystemThread(PHANDLE ThreadHandle,ACCESS_MASK DesiredAccess,POBJECT_ATTRIBUTES ObjectAttributes,
		HANDLE ProcessHandle,PCLIENT_ID ClientId,PKSTART_ROUTINE StartRoutine,PVOID StartContext)
{
	g_return_val_if_fail(ThreadHandle!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(StartRoutine!=NULL,STATUS_INVALID_PARAMETER);

	/* FIXME: Cooperative multitasking enqueue! */

	*ThreadHandle=(HANDLE)&PsCreateSystemThread_bogusthread;

	return STATUS_SUCCESS;
}
