/* $Id: math.c,v 1.4 2003/04/08 18:00:33 short Exp $
 * long-value math emulation for support of ntoskrnl of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ntos/types.h"
#include <glib/gmessages.h>


/**
 * _allmul:
 * @a: First #LONGLONG multiplier.
 * @b: Second #LONGLONG multiplier.
 *
 * Returns: @a * @b. No overflows are checked.
 */
LONGLONG _allmul(LONGLONG a,LONGLONG b)
{
	return a*b;
}


/**
 * _alldiv:
 * @a: #LONGLONG divisor.
 * @b: #LONGLONG divider.
 * Value %0 is forbidden.
 *
 * Returns: @a / @b.
 */
LONGLONG _alldiv(LONGLONG a,LONGLONG b)
{
	g_return_val_if_fail(b!=0,0);

	return a/b;
}


/**
 * _allshl:
 * @long_00to31: Lower part of 64-bit unsigned number to shift.
 * @long_32to63: Upper part of 64-bit unsigned number to shift.
 * @count: Number of bits to shift by.
 *
 * 64-bit shift left by @count bits.
 *
 * This is a special function which is declared as %data in *.def
 * file ke/exports.def as it has three arguments passed in registers.
 *
 * Returns: (@long_32to63 @long_00to31) shifted left by @count bits.
 */
guint64 __attribute__((__stdcall__)) __attribute__((__regparm__(3))) _allshl(
		guint32 long_00to31,	/* %eax */
		guint32 long_32to63,	/* %edx */
		guint8	count)	/* %ecx */
{
	return (((((guint64)long_32to63)<<32U)|long_00to31)<<count);
}


/**
 * _allshr:
 * @long_00to31: Lower part of 64-bit signed number to shift.
 * @long_32to63: Upper part of 64-bit signed number to shift.
 * @count: Number of bits to shift by.
 *
 * 64-bit shift right by @count bits.
 *
 * WARNING: Although this function is call _allshr() it in fact implements
 * instruction %sar, NOT %shr!
 *
 * This is a special function which is declared as %data in *.def
 * file ke/exports.def as it has three arguments passed in registers.
 *
 * Returns: (@long_32to63 @long_00to31) signed-shifted right by @count bits.
 */
guint64 __attribute__((__stdcall__)) __attribute__((__regparm__(3))) _allshr(
		guint32 long_00to31,	/* %eax */
		guint32 long_32to63,	/* %edx */
		guint8	count)	/* %ecx */
{
	return (((((gint64)long_32to63)<<32U)|long_00to31)>>count);
}


/**
 * _aullshr:
 * @long_00to31: Lower part of 64-bit unsigned number to shift.
 * @long_32to63: Upper part of 64-bit unsigned number to shift.
 * @count: Number of bits to shift by.
 *
 * 64-bit shift right by @count bits.
 *
 * This is a special function which is declared as %data in *.def
 * file ke/exports.def as it has three arguments passed in registers.
 *
 * Returns: (@long_32to63 @long_00to31) unsigned-shifted right by @count bits.
 */
guint64 __attribute__((__stdcall__)) __attribute__((__regparm__(3))) _aullshr(
		guint32 long_00to31,	/* %eax */
		guint32 long_32to63,	/* %edx */
		guint8	count)	/* %ecx */
{
	return (((((guint64)long_32to63)<<32U)|long_00to31)>>count);
}


/**
 * _allrem:
 * @divident: 64-bit signed divident.
 * @divisor: 64-bit signed divisor.
 *
 * Calculates the signed modulo of two 64-bit numbers.
 *
 * FIXME: Are we expected to behave signed?
 *
 * Returns: Expression "divident%divisor".
 */
gint64 _allrem(gint64 divident,gint64 divisor)
{
	return divident%divisor;
}
