/* $Id: ps_reactos.c,v 1.2 2003/09/16 08:48:57 short Exp $
 * reactos processor emulation for support of ntoskrnl of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/ps_reactos.h"	/* self */
#include "captive/macros.h"


/* Do not use static variable here:
 * We would not get ElectricFence checks on accesses
 * in original ReactOS 'KPCR'/'IKPCR' structure manner.
 */
static captive_KPCR *captive_KeGetCurrentKPCR_KPCR;

/**
 * captive_KeGetCurrentKPCR:
 *
 * Returns the #PCR (Processor Control Region) structure for the
 * current CPU.
 * Currently libcaptive doesn't use multithreading
 * and thus this function returns a constant pointer to one static structure.
 *
 * Returns: #captive_PKPCR type pointer to valid #captive_KPCR.
 * This structure IS NOT binary compatible with reactos - you SHOULD NOT
 * export this symbol for binary W32 modules. Anyone using this function
 * is very low-level based and you would probably find many other
 * compatibility problems afterwards - replace of such function is recommended.
 */
captive_PKPCR captive_KeGetCurrentKPCR(void)
{
	/* TODO:thread */
	if (!captive_KeGetCurrentKPCR_KPCR)
		captive_new0(captive_KeGetCurrentKPCR_KPCR);
	return captive_KeGetCurrentKPCR_KPCR;
}
