/* $Id: thread.c,v 1.1 2003/07/04 04:23:25 short Exp $
 * Kernel thread handling functions of ntoskrnl of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include "reactos/internal/ps.h"	/* for PKTHREAD */
#include <glib/gmessages.h>


/**
 * KeSetPriorityThread:
 * @Thread: Driver thread structure address to set its priority.
 * libcaptive currently supports only KeGetCurrentThread() value here.
 * %NULL value is forbidden.
 * @Priority: Wished new priority for @Thread.
 *
 * Sets thread priority to @Priority. Currently ignored by libcaptive.
 *
 * Returns: Previous priority of @Thread. libcaptive always returns 0.
 */
KPRIORITY KeSetPriorityThread(PKTHREAD Thread,KPRIORITY Priority)
{
	g_return_val_if_fail(Thread!=NULL,0);
	g_return_val_if_fail(Thread==KeGetCurrentThread(),0);	/* TODO:thread */

	return 0;
}
