/* $Id: ctype.c,v 1.1 2005/12/17 02:23:07 lace Exp $
 * reactos character handling functions emulation of libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include "reactos/ntos/rtl.h"	/* self */
#include <wctype.h>


/**
 * captive_reactos_towupper:
 * @c: Any-case character to convert.
 *
 * Wrapper of the system towupper() for the use by ReactOS.
 * The ReactOS implementation does not provide full Unicode support.
 *
 * Returns: Uppercased @c. Original value is returned if the case cannot be
 * changed.
 */
wchar_t captive_reactos_towupper(wchar_t c)
{
	return towupper(c);
}
