/* $Id: error.c,v 1.5 2003/05/01 09:04:18 short Exp $
 * Error handling implementation for reactos of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ntos/rtl.h"	/* self */
#include <glib/gmessages.h>


/**
 * RtlAssert:
 * @FailedAssertion: Failed-assertion expression given as string.
 * %NULL value is forbidden.
 * @FileName: Filename string where the assertion occured.
 * %NULL value is forbidden.
 * @LineNumber: Line number of @FileName where the assertion occured.
 * @Message: Message to print.
 * %NULL value is permitted.
 *
 * Prints the specified error message and bails out.
 * This call never returns in libcaptive.
 */
VOID RtlAssert(PVOID FailedAssertion,PVOID FileName,ULONG LineNumber,PCHAR Message)
{
	g_return_if_fail(FailedAssertion!=NULL);
	g_return_if_fail(FileName!=NULL);

	g_error("Assertion \'%s\' failed at %s line %d: %s\n",
		(const gchar *)FailedAssertion,(const gchar *)FileName,(gint)LineNumber,
		(Message ? Message : "(no message)"));

	g_assert_not_reached();
}
