/* $Id: except.c,v 1.2 2003/07/04 05:36:30 short Exp $
 * Implementation of reactos RtlpExecuteHandler() of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

/* No reactos public include prototype for RtlpExecuteHandlerForException() */
#include <glib/gtypes.h>
#include <glib/gmessages.h>
#include "reactos/ntos/except.h"


EXCEPTION_DISPOSITION RtlpExecuteHandlerForException(PEXCEPTION_RECORD ExceptionRecord,
		PEXCEPTION_REGISTRATION RegistrationFrame,PCONTEXT Context,PVOID DispatcherContext,PEXCEPTION_HANDLER ExceptionHandler)
{
static gint nested=0;
EXCEPTION_DISPOSITION r;

	g_return_val_if_fail(ExceptionRecord!=NULL,ExceptionNestedException);
	g_return_val_if_fail(RegistrationFrame!=NULL,ExceptionNestedException);
	/* 'Context' can be NULL during ExRaiseStatus() */
	g_return_val_if_fail(DispatcherContext!=NULL,ExceptionNestedException);
	g_return_val_if_fail(ExceptionHandler!=NULL,ExceptionNestedException);

	/* Nest-counting is provided here just for debugging reasons. */
	/* Nesting must be permitted for proper FSCTL_DISMOUNT_VOLUME execution. */

	nested++;
	r=(*ExceptionHandler)(ExceptionRecord,RegistrationFrame,Context,DispatcherContext);
	nested--;
	g_assert(nested>=0);

	g_assert(r==ExceptionContinueExecution || r==ExceptionContinueSearch);
	return r;
}


EXCEPTION_DISPOSITION RtlpExecuteHandlerForUnwind(PEXCEPTION_RECORD ExceptionRecord,
		PEXCEPTION_REGISTRATION RegistrationFrame,PCONTEXT Context,PVOID DispatcherContext,PEXCEPTION_HANDLER ExceptionHandler)
{
static gint nested=0;
EXCEPTION_DISPOSITION r;

	g_return_val_if_fail(ExceptionRecord!=NULL,ExceptionNestedException);
	g_return_val_if_fail(RegistrationFrame!=NULL,ExceptionNestedException);
	/* 'Context' can be NULL during ExRaiseStatus() */
	g_return_val_if_fail(DispatcherContext!=NULL,ExceptionNestedException);
	g_return_val_if_fail(ExceptionHandler!=NULL,ExceptionNestedException);

	/* Nest-counting is provided here just for debugging reasons. */
	if (nested)
		g_assert_not_reached();

	nested++;
	r=(*ExceptionHandler)(ExceptionRecord,RegistrationFrame,Context,DispatcherContext);
	nested--;
	g_assert(!nested);

	g_assert(r==ExceptionContinueExecution || r==ExceptionContinueSearch);
	return r;
}
