/* $Id: memset.c,v 1.2 2003/02/13 09:52:39 short Exp $
 * captive_reactos_memset() for reactos wrapper of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ntos/rtl.h"	/* self */
#include <glib/gmessages.h>
#include <string.h>


/**
 * captive_reactos_memset:
 * @src: Memory area to fill.
 * %NULL value is forbidden.
 * @val: #guint8 byte value to fill the area by.
 * @count: Length of the area.
 * Value %0 is permitted (NOP in such case).
 *
 * Simple wrapper around system memset() to prevent possible declaration conflicts.
 *
 * Returns: The same pointer @src as received.
 */
void *captive_reactos_memset(void *src, int val, size_t count)
{
void *r;

	g_return_val_if_fail(src!=NULL,NULL);

	r=memset(src,val,count);
	g_assert(r==src);

	return r;
}
