/* $Id: string.c,v 1.2 2003/02/13 09:52:39 short Exp $
 * captive_reactos_str*() for reactos wrappers of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ntos/rtl.h"	/* self */
#include <glib/gmessages.h>
#include <string.h>


/**
 * captive_reactos_strchr:
 * @s: 0-terminated string to search @c in.
 * %NULL value is forbidden.
 * @c: #guint8 byte to search for in @s.
 *
 * Simple wrapper around system strchr() to prevent possible declaration conflicts.
 *
 * Returns: Pointer to the found @c in @s or %NULL if not found.
 */
char *captive_reactos_strchr(const char *s, int c)
{
	g_return_val_if_fail(s!=NULL,NULL);

	return strchr(s,c);
}


/**
 * captive_reactos_strcmp:
 * @s1: 0-terminated first string to compare.
 * %NULL value is forbidden.
 * @s2: 0-terminated second string to compare.
 * %NULL value is forbidden.
 *
 * Simple wrapper around system strcmp() to prevent possible declaration conflicts.
 *
 * Returns: integer less than, equal to, or greater than zero if @s1 (or the
 * first n bytes thereof) is found, respectively, to be less than, to match, or
 * be greater than @s2.
 */
int captive_reactos_strcmp(const char *s1, const char *s2)
{
	g_return_val_if_fail(s1!=NULL,0);
	g_return_val_if_fail(s2!=NULL,0);

	return strcmp(s1,s2);
}


/**
 * captive_reactos_strcpy:
 * @to: Target memory to copy @from to.
 * %NULL value is forbidden.
 * @s2: 0-terminated string to copy to @to.
 * %NULL value is forbidden.
 *
 * Simple wrapper around system strcpy() to prevent possible declaration conflicts.
 *
 * Returns: The same pointer @to as received.
 */
char *captive_reactos_strcpy(char *to, const char *from)
{
char *r;

	g_return_val_if_fail(to!=NULL,NULL);
	g_return_val_if_fail(from!=NULL,NULL);

	r=strcpy(to,from);
	g_assert(r==to);

	return r;
}


/**
 * captive_reactos_strlen:
 * @str: 0-terminated string to measure its length.
 * %NULL value is forbidden.
 *
 * Simple wrapper around system strlen() to prevent possible declaration conflicts.
 *
 * Returns: Number of characters in @str.
 */
size_t captive_reactos_strlen(const char *str)
{
	g_return_val_if_fail(str!=NULL,0);

	return strlen(str);
}
