/* $Id: unicode_reactos.c,v 1.1 2002/10/31 17:37:52 short Exp $
 * Unicode support used also for reactos files for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/unicode_reactos.h"	/* self */
#include "captive/unicode.h"
#include <glib/gtypes.h>
#include <glib/gmessages.h>


/**
 * captive_ucs4_to_ucs2_const:
 * @string_ucs4: #const #gunichar * type of persistent string to convert.
 * This string MUST remain readable with the same content forever.
 * This string MUST be convertible to UCS-2 string.
 *
 * Constant string conversion from 32-bit #wchar_t to 16-bit #wchar_t.
 * You may not modify the result in any way.
 * 
 * It is guaranteed to get two different string addresses for two different
 * input addresses even if the input strings content is the same.
 * Otherwise we would behave as #GCC option %-fmerge-constants which
 * results in %C non-conforming behaviour.
 *
 * Returns: #const #captive_ucs2 * converted string @string_ucs4.
 */
const captive_ucs2 *captive_ucs4_to_ucs2_const(const gunichar *string_ucs4)
{
const captive_ucs2 *r;

	g_return_val_if_fail(captive_validate_ucs4(string_ucs4),captive_ucs4_to_ucs2_const((const gunichar *)L""));

	r=(const captive_ucs2 *)captive_ucs4_to_utf16_const(string_ucs4);

	/* Here we can bail out on non-UCS-2 compliant UTF-16 string */
	g_return_val_if_fail(captive_validate_ucs2(r),captive_ucs4_to_ucs2_const((const gunichar *)L""));

	return r;
}
