/* $Id: version.c,v 1.1 2003/03/24 00:13:27 short Exp $
 * Internal (rtl/) reactos versioning functions of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

/* no include file for RtlGetVersion() in reactos */
#include <glib/gmessages.h>
#include "reactos/ntos/types.h"
#include "reactos/ddk/status.h"
#include "captive/macros.h"


typedef struct _OSVERSIONINFOW {
	ULONG dwOSVersionInfoSize;
	ULONG dwMajorVersion;
	ULONG dwMinorVersion;
	ULONG dwBuildNumber;
	ULONG dwPlatformId;
	WCHAR szCSDVersion[128];
	} RTL_OSVERSIONINFOW,*PRTL_OSVERSIONINFOW;
 
typedef struct _OSVERSIONINFOEXW {	/* sizeof==284 */
	ULONG dwOSVersionInfoSize;
	ULONG dwMajorVersion;
	ULONG dwMinorVersion;
	ULONG dwBuildNumber;
	ULONG dwPlatformId;
	WCHAR szCSDVersion[128];
	USHORT wServicePackMajor;
	USHORT wServicePackMinor;
	USHORT wSuiteMask;
	UCHAR wProductType;
	UCHAR wReserved;
} RTL_OSVERSIONINFOEXW,*PRTL_OSVERSIONINFOEXW;


/**
 * RtlGetVersion:
 * @lpVersionInformation: Returns system version information.
 *
 * Functions looks at field #dwOSVersionInfoSize of @lpVersionInformation
 * containing sizeof() of the passed structure to autodetect what it should
 * in fact fill in.
 * libcaptive currently supports only #RTL_OSVERSIONINFOEXW.
 * libcaptive returns version info corresponding to Microsoft Windows XP Service Pack 1.
 *
 * Returns: %STATUS_SUCCESS if @lpVersionInformation was filled successfuly.
 */
NTSTATUS RtlGetVersion(OUT PRTL_OSVERSIONINFOW lpVersionInformation)
{
	g_return_val_if_fail(lpVersionInformation!=NULL,STATUS_INVALID_PARAMETER);

	switch (lpVersionInformation->dwOSVersionInfoSize) {
		case sizeof(RTL_OSVERSIONINFOEXW): {
RTL_OSVERSIONINFOEXW *verinfoexw=(RTL_OSVERSIONINFOEXW *)lpVersionInformation;

			verinfoexw->dwMajorVersion=5;	/* NT-5.1 == Microsoft Windows XP */
			verinfoexw->dwMinorVersion=1;
			verinfoexw->dwBuildNumber=2600;
			verinfoexw->dwPlatformId=2;	/* ==Wine::VER_PLATFORM_WIN32_NT */
			CAPTIVE_MEMZERO(verinfoexw->szCSDVersion);	/* FIXME: should be L"Service Pack 1" ? */
			verinfoexw->wServicePackMajor=1;	/* Wine uses 0 */
			verinfoexw->wServicePackMinor=0;
			verinfoexw->wSuiteMask=0;
			verinfoexw->wProductType=1;	/* ==Wine::VER_NT_WORKSTATION, possible also VER_NT_DOMAIN_CONTROLLER or VER_NT_SERVER */
			verinfoexw->wReserved=0;
			} break;
		default:
			g_assert_not_reached();	/* NOT YET IMPLEMENTED */
		}

	return STATUS_SUCCESS;
}
