/* $Id: FileInfo.c,v 1.5 2006/01/01 07:24:34 lace Exp $
 * CORBA/ORBit server side of GnomeVFSFileInfo handling
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "FileInfo.h"	/* self */
#include <glib/gmessages.h>


GnomeVFSResult captive_sandbox_file_info_corba_to_captive
		(CaptiveFileInfoObject *file_info_captive,const Captive_CaptiveFileInfoObject *file_info_corba)
{
	g_return_val_if_fail(file_info_captive!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(file_info_corba!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(file_info_captive->p.valid_fields==0,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(file_info_captive->p.name==NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	file_info_captive->p.valid_fields=0;
	file_info_captive->p.name=g_strdup(file_info_corba->name);
	if (file_info_corba->type_valid) {
		file_info_captive->p.type=file_info_corba->type;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_TYPE;
		}
	if (file_info_corba->permissions_valid) {
		file_info_captive->p.permissions=file_info_corba->permissions;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_PERMISSIONS;
		}
	if (file_info_corba->size_valid) {
		file_info_captive->p.size=file_info_corba->size;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_SIZE;
		}
	if (file_info_corba->block_count_valid) {
		file_info_captive->p.block_count=file_info_corba->block_count;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_BLOCK_COUNT;
		}
	if (file_info_corba->atime) {
		file_info_captive->p.atime=file_info_corba->atime;
		file_info_captive->atime_nsec=file_info_corba->atime_nsec;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_ATIME;
		}
	if (file_info_corba->mtime) {
		file_info_captive->p.mtime=file_info_corba->mtime;
		file_info_captive->mtime_nsec=file_info_corba->mtime_nsec;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_MTIME;
		}
	if (file_info_corba->ctime) {
		file_info_captive->p.ctime=file_info_corba->ctime;
		file_info_captive->ctime_nsec=file_info_corba->ctime_nsec;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_CTIME;
		}
	if (file_info_corba->flags_valid) {
		file_info_captive->p.flags=file_info_corba->flags;
		file_info_captive->p.valid_fields|=GNOME_VFS_FILE_INFO_FIELDS_FLAGS;
		}

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_file_info_captive_to_corba
		(Captive_CaptiveFileInfoObject *file_info_corba,const CaptiveFileInfoObject *file_info_captive)
{
	g_return_val_if_fail(file_info_corba!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(file_info_captive!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	if (!file_info_captive->p.name)
		file_info_corba->name=CORBA_string_dup("");
	else
		file_info_corba->name=CORBA_string_dup(file_info_captive->p.name);
	if ((file_info_corba->type_valid=!!(file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_TYPE)))
		file_info_corba->type=file_info_captive->p.type;
	if ((file_info_corba->permissions_valid=!!(file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_PERMISSIONS)))
		file_info_corba->permissions=file_info_captive->p.permissions;
	if ((file_info_corba->size_valid=!!(file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_SIZE)))
		file_info_corba->size=file_info_captive->p.size;
	if ((file_info_corba->block_count_valid=!!(file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_BLOCK_COUNT)))
		file_info_corba->block_count=file_info_captive->p.block_count;
	if (!file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_ATIME) {
		file_info_corba->atime     =0;
		file_info_corba->atime_nsec=0;
		}
	else {
		file_info_corba->atime=file_info_captive->p.atime;
		file_info_corba->atime_nsec=file_info_captive->atime_nsec;
		}
	if (!file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_MTIME) {
		file_info_corba->mtime     =0;
		file_info_corba->mtime_nsec=0;
		}
	else {
		file_info_corba->mtime=file_info_captive->p.mtime;
		file_info_corba->mtime_nsec=file_info_captive->mtime_nsec;
		}
	if (!file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_CTIME) {
		file_info_corba->ctime     =0;
		file_info_corba->ctime_nsec=0;
		}
	else {
		file_info_corba->ctime=file_info_captive->p.ctime;
		file_info_corba->ctime_nsec=file_info_captive->ctime_nsec;
		}
	if ((file_info_corba->flags_valid=!!(file_info_captive->p.valid_fields&GNOME_VFS_FILE_INFO_FIELDS_FLAGS)))
		file_info_corba->flags=file_info_captive->p.flags;

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_file_info_set_mask_captive_to_corba
		(Captive_CaptiveFileInfoObject *file_info_corba,const CaptiveFileInfoObject *file_info_captive,GnomeVFSSetFileInfoMask mask)
{
	g_return_val_if_fail(file_info_corba!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(file_info_captive!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	/* uninitialized: file_info_corba->name */
	file_info_corba->type_valid=CORBA_FALSE;
	file_info_corba->permissions_valid=CORBA_FALSE;
	file_info_corba->size_valid=CORBA_FALSE;
	file_info_corba->block_count_valid=CORBA_FALSE;
	file_info_corba->atime     =0;
	file_info_corba->atime_nsec=0;
	file_info_corba->mtime     =0;
	file_info_corba->mtime_nsec=0;
	file_info_corba->ctime     =0;
	file_info_corba->ctime_nsec=0;
	file_info_corba->flags_valid=CORBA_FALSE;

	if (!(mask&GNOME_VFS_SET_FILE_INFO_NAME))
		file_info_corba->name=CORBA_string_dup("");
	else
		file_info_corba->name=CORBA_string_dup(file_info_captive->p.name);
	if ((file_info_corba->permissions_valid=!!(mask&GNOME_VFS_SET_FILE_INFO_PERMISSIONS)))
		file_info_corba->permissions=file_info_captive->p.permissions;
	/* Not implemented by libcaptive: GNOME_VFS_SET_FILE_INFO_OWNER */
	if (mask&GNOME_VFS_SET_FILE_INFO_TIME) {
		file_info_corba->atime     =file_info_captive->p.atime;
		file_info_corba->atime_nsec=file_info_captive->atime_nsec;
		file_info_corba->mtime     =file_info_captive->p.mtime;
		file_info_corba->mtime_nsec=file_info_captive->mtime_nsec;
		file_info_corba->ctime     =file_info_captive->p.ctime;
		file_info_corba->ctime_nsec=file_info_captive->ctime_nsec;
		}

	return GNOME_VFS_OK;
}
