/* $Id: client-CaptiveIOChannel.c,v 1.5 2003/12/06 14:04:54 short Exp $
 * CORBA/ORBit client side of image GIOChannel object of sandbox_child()
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "client-CaptiveIOChannel.h"	/* self */
#include <glib/gmessages.h>
#include "split.h"
#include <string.h>
#include "captive/macros.h"
#include "../client/lib.h"	/* for captive_giochannel_setup() */


struct captive_io_channel {
	GIOChannel iochannel;
	Captive_CaptiveIOChannel corba_captive_io_channel;
	};


G_LOCK_DEFINE_STATIC(captive_io_channel_funcs);
static GIOFuncs captive_io_channel_funcs;


static gboolean validate_captive_io_channel(struct captive_io_channel *captive_io_channel)
{
	g_return_val_if_fail(captive_io_channel!=NULL,FALSE);
	g_return_val_if_fail(captive_io_channel->corba_captive_io_channel!=NULL,FALSE);

	return TRUE;
}


static GIOStatus captive_io_channel_io_read
		(GIOChannel *channel,gchar *buffer_captive,gsize count,gsize *bytes_read_return,GError **err)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;
Captive_Bytes *buffer_corba;

	g_return_val_if_fail(validate_captive_io_channel(captive_io_channel),G_IO_STATUS_ERROR);
	g_return_val_if_fail(buffer_captive!=NULL,G_IO_STATUS_ERROR);
	g_return_val_if_fail(bytes_read_return!=NULL,G_IO_STATUS_ERROR);

	*bytes_read_return=0;

	Captive_CaptiveIOChannel_read(captive_io_channel->corba_captive_io_channel,&buffer_corba,count,&captive_corba_ev);
	if (GNOME_VFS_OK!=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,NULL))
		return G_IO_STATUS_ERROR;

	g_return_val_if_fail(buffer_corba->_length<=count,G_IO_STATUS_ERROR);
	memcpy(buffer_captive,buffer_corba->_buffer,buffer_corba->_length);
	*bytes_read_return=buffer_corba->_length;

	Captive_Bytes__freekids(buffer_corba,NULL/* 'd'; meaning? */);
	CORBA_free(buffer_corba);

	return (*bytes_read_return == 0 ? G_IO_STATUS_EOF : G_IO_STATUS_NORMAL);
}


static GIOStatus captive_io_channel_io_write
		(GIOChannel *channel,const gchar *buffer_captive,gsize count,gsize *bytes_written_return,GError **err)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;
Captive_Bytes buffer_corba_local;
Captive_GSize bytes_written_corba;

	g_return_val_if_fail(validate_captive_io_channel(captive_io_channel),G_IO_STATUS_ERROR);
	g_return_val_if_fail(buffer_captive!=NULL,G_IO_STATUS_ERROR);
	g_return_val_if_fail(bytes_written_return!=NULL,G_IO_STATUS_ERROR);

	*bytes_written_return=0;

	buffer_corba_local._maximum=count;
	buffer_corba_local._length=count;
	buffer_corba_local._buffer=(/* de-const */gpointer)buffer_captive;
	buffer_corba_local._release=FALSE;

	Captive_CaptiveIOChannel_write(captive_io_channel->corba_captive_io_channel,
			&buffer_corba_local,&bytes_written_corba,&captive_corba_ev);
	if (GNOME_VFS_OK!=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,NULL))
		return G_IO_STATUS_ERROR;

	*bytes_written_return=bytes_written_corba;

	return G_IO_STATUS_NORMAL;
}


static GIOStatus captive_io_channel_io_seek(GIOChannel *channel,gint64 offset,GSeekType type,GError **err)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;

	g_return_val_if_fail(validate_captive_io_channel(captive_io_channel),G_IO_STATUS_ERROR);

	Captive_CaptiveIOChannel_seek(captive_io_channel->corba_captive_io_channel,offset,type,&captive_corba_ev);
	if (GNOME_VFS_OK!=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,NULL))
		return G_IO_STATUS_ERROR;

	return G_IO_STATUS_NORMAL;
}


static GIOStatus captive_io_channel_io_close(GIOChannel *channel,GError **err)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;

	g_return_val_if_fail(validate_captive_io_channel(captive_io_channel),G_IO_STATUS_ERROR);

	/* We are not authorized to destroy 'captive_io_channel->corba_captive_io_channel'. */
	/* flush()? */
	captive_io_channel->corba_captive_io_channel=NULL;

	return G_IO_STATUS_NORMAL;
}


static GSource* captive_io_channel_io_create_watch(GIOChannel *channel,GIOCondition condition)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;

	g_return_val_if_fail(validate_captive_io_channel(captive_io_channel),NULL);

	g_return_val_if_reached(NULL);	/* FIXME: NOT IMPLEMENTED YET */
}


static void captive_io_channel_io_free(GIOChannel *channel)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;

	/* After captive_io_channel_io_close() 'captive_io_channel'
	 * may be no longer valid for validate_captive_io_channel(captive_io_channel).
	 */
	g_return_if_fail(captive_io_channel!=NULL);

	g_assert(captive_io_channel->corba_captive_io_channel==NULL);

	g_free(captive_io_channel);
}


static GIOStatus captive_io_channel_io_set_flags(GIOChannel *channel,GIOFlags flags,GError **err)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;

	g_return_val_if_fail(validate_captive_io_channel(captive_io_channel),G_IO_STATUS_ERROR);

	/* no G_IO_FLAG_APPEND and no G_IO_FLAG_NONBLOCK */
	g_return_val_if_fail((flags&G_IO_FLAG_SET_MASK)==0,G_IO_STATUS_ERROR);

	return G_IO_STATUS_NORMAL;
}


static GIOFlags captive_io_channel_io_get_flags(GIOChannel *channel)
{
struct captive_io_channel *captive_io_channel=(struct captive_io_channel *)channel;

	g_return_val_if_fail(validate_captive_io_channel(captive_io_channel),0);

	return 0;	/* | !G_IO_FLAG_APPEND | !G_IO_FLAG_NONBLOCK */
}


struct captive_io_channel *captive_io_channel_new(Captive_CaptiveIOChannel corba_captive_io_channel,gboolean writeable)
{
struct captive_io_channel *captive_io_channel;

	g_return_val_if_fail(corba_captive_io_channel!=NULL,NULL);

	G_LOCK(captive_io_channel_funcs);
	captive_io_channel_funcs.io_read        =captive_io_channel_io_read;
	captive_io_channel_funcs.io_write       =captive_io_channel_io_write;
	captive_io_channel_funcs.io_seek        =captive_io_channel_io_seek;
	captive_io_channel_funcs.io_close       =captive_io_channel_io_close;
	captive_io_channel_funcs.io_create_watch=captive_io_channel_io_create_watch;
	captive_io_channel_funcs.io_free        =captive_io_channel_io_free;
	captive_io_channel_funcs.io_set_flags   =captive_io_channel_io_set_flags;
	captive_io_channel_funcs.io_get_flags   =captive_io_channel_io_get_flags;
	G_UNLOCK(captive_io_channel_funcs);

	captive_new(captive_io_channel);
	g_assert(G_STRUCT_OFFSET(struct captive_io_channel,iochannel)==0);	/* safely re-type-able */
	g_io_channel_init(&captive_io_channel->iochannel);
	captive_io_channel->iochannel.funcs=&captive_io_channel_funcs;
	captive_io_channel->iochannel.is_seekable=TRUE;
	captive_io_channel->iochannel.is_readable=TRUE;
	captive_io_channel->iochannel.is_writeable=writeable;
	captive_io_channel->iochannel.close_on_unref=TRUE;	/* run g_io_channel_shutdown() flush on last unref */
	captive_io_channel->corba_captive_io_channel=corba_captive_io_channel;

	captive_giochannel_setup(&captive_io_channel->iochannel);

	return captive_io_channel;
}


gboolean captive_io_channel_get_size(GIOChannel *giochannel,guint64 *size_return)
{
struct captive_io_channel *captive_io_channel;

	g_return_val_if_fail(giochannel!=NULL,FALSE);
	g_return_val_if_fail(size_return!=NULL,FALSE);

	if (giochannel->funcs!=&captive_io_channel_funcs)
		return FALSE;
	captive_io_channel=(struct captive_io_channel *)giochannel;

	*size_return=Captive_CaptiveIOChannel_size(captive_io_channel->corba_captive_io_channel,&captive_corba_ev);
	if (GNOME_VFS_OK!=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,NULL))
		return FALSE;

	return TRUE;
}
