/* $Id: parent-File.c,v 1.15 2006/01/01 07:24:34 lace Exp $
 * CORBA/ORBit client side of File object of sandbox_parent()
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "parent-File.h"	/* self */
#include <glib/gmessages.h>
#include "split.h"
#include "sandbox.h"
#include "../client/file.h"
#include "../client/vfs.h"
#include "FileInfo.h"
#include "captive/macros.h"
#include "reactos/ntos/types.h"	/* for ULONG */


GnomeVFSResult captive_sandbox_parent_file_new_open(CaptiveFileParentObject *captive_file_parent_object)
{
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;
GnomeVFSResult r;
Captive_File corba_File_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(captive_file_parent_object->pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_new_open",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		xmlNewProp(xml_action,BAD_CAST "pathname",BAD_CAST captive_file_parent_object->pathname);
		xmlNewProp(xml_action,BAD_CAST "mode",BAD_CAST captive_printf_alloca("%u",(unsigned)captive_file_parent_object->mode));
		}

	corba_File_object=Captive_Vfs_file_new_open(captive_vfs_parent_object->corba_Vfs_object,
			captive_file_parent_object->pathname,captive_file_parent_object->mode,&captive_corba_ev);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST (captive_corba_ev._major==CORBA_NO_EXCEPTION ? "1" : "0"));
	/* If 'r' means failure 'corba_File_object' may not be 'CORBA_OBJECT_NIL'
	 * although it is not valid 'CORBA_Object' to be passed to CORBA_Object_release().
	 */
	if (GNOME_VFS_OK!=(r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object)))
		return r;

	captive_file_parent_object->corba_File_object=corba_File_object;
	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_new_create(CaptiveFileParentObject *captive_file_parent_object,
		gboolean exclusive,guint perm)
{
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;
GnomeVFSResult r;
Captive_File corba_File_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(captive_file_parent_object->pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_new_create",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		xmlNewProp(xml_action,BAD_CAST "pathname",BAD_CAST captive_file_parent_object->pathname);
		xmlNewProp(xml_action,BAD_CAST "mode",BAD_CAST captive_printf_alloca("%u",(unsigned)captive_file_parent_object->mode));
		xmlNewProp(xml_action,BAD_CAST "exclusive",BAD_CAST captive_printf_alloca("%u",(unsigned)exclusive));
		xmlNewProp(xml_action,BAD_CAST "perm",BAD_CAST captive_printf_alloca("%u",(unsigned)perm));
		}

	corba_File_object=Captive_Vfs_file_new_create(captive_vfs_parent_object->corba_Vfs_object,
			captive_file_parent_object->pathname,captive_file_parent_object->mode,exclusive,perm,&captive_corba_ev);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST (captive_corba_ev._major==CORBA_NO_EXCEPTION ? "1" : "0"));
	/* If 'r' means failure 'corba_File_object' may not be 'CORBA_OBJECT_NIL'
	 * although it is not valid 'CORBA_Object' to be passed to CORBA_Object_release().
	 */
	if (GNOME_VFS_OK!=(r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object)))
		return r;

	captive_file_parent_object->corba_File_object=corba_File_object;
	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_close(CaptiveFileParentObject *captive_file_parent_object)
{
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_close",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		}

	Captive_File_shutdown(captive_file_parent_object->corba_File_object,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));

	/* Always clear 'corba_File_object' even if 'r' means failure. */
	CORBA_Object_release((CORBA_Object)captive_file_parent_object->corba_File_object,&captive_corba_ev);
	captive_file_parent_object->corba_File_object=CORBA_OBJECT_NIL;

	return r;
}


static GnomeVFSResult captive_sandbox_parent_file_seek_slave
		(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSSeekPosition whence,GnomeVFSFileOffset offset);

GnomeVFSResult captive_sandbox_parent_file_read(CaptiveFileParentObject *captive_file_parent_object,
		gpointer buffer_captive,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_read_return)
{
GnomeVFSResult r;
Captive_Bytes *buffer_corba;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(buffer_captive!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(bytes_read_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(num_bytes==(ULONG)num_bytes,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	*bytes_read_return=0;

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_read",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		xmlNewProp(xml_action,BAD_CAST "num_bytes",BAD_CAST captive_printf_alloca("%lu",(unsigned long)num_bytes));
		}

	r=captive_sandbox_parent_file_seek_slave(captive_file_parent_object,
			GNOME_VFS_SEEK_START,captive_file_parent_object->offset);
	if (r==GNOME_VFS_OK) {
		Captive_File_read(captive_file_parent_object->corba_File_object,&buffer_corba,num_bytes,&captive_corba_ev);
		r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
		}
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	g_return_val_if_fail(buffer_corba->_length<=num_bytes,GNOME_VFS_ERROR_GENERIC);
	memcpy(buffer_captive,buffer_corba->_buffer,buffer_corba->_length);
	*bytes_read_return=buffer_corba->_length;
	captive_file_parent_object->offset+=buffer_corba->_length;

	Captive_Bytes__freekids(buffer_corba,NULL/* 'd'; meaning? */);
	CORBA_free(buffer_corba);

	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "bytes_read_return",BAD_CAST captive_printf_alloca("%lu",(unsigned long)*bytes_read_return));

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_write(CaptiveFileParentObject *captive_file_parent_object,
		gconstpointer buffer_captive,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_written_return)
{
GnomeVFSResult r;
Captive_Bytes buffer_corba_local;
Captive_GnomeVFSFileSize bytes_written_corba;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(buffer_captive!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(bytes_written_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(num_bytes==(ULONG)num_bytes,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	*bytes_written_return=0;

	r=captive_sandbox_parent_file_seek_slave(captive_file_parent_object,
			GNOME_VFS_SEEK_START,captive_file_parent_object->offset);
	if (r==GNOME_VFS_OK) {

		if (captive_vfs_parent_object->corba_bug_action) {
			xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_write",NULL);
			xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
			xmlNewProp(xml_action,BAD_CAST "num_bytes",BAD_CAST captive_printf_alloca("%lu",(unsigned long)num_bytes));
			}

		buffer_corba_local._maximum=num_bytes;
		buffer_corba_local._length=num_bytes;
		buffer_corba_local._buffer=(/* de-const */gpointer)buffer_captive;
		buffer_corba_local._release=FALSE;

		Captive_File_write(captive_file_parent_object->corba_File_object,
				&buffer_corba_local,&bytes_written_corba,&captive_corba_ev);
		r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
		if (xml_action)
			xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
		}
	if (r!=GNOME_VFS_OK)
		return r;

	*bytes_written_return=bytes_written_corba;
	captive_file_parent_object->offset+=bytes_written_corba;

	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "bytes_written_return",BAD_CAST captive_printf_alloca("%lu",(unsigned long)*bytes_written_return));

	return GNOME_VFS_OK;
}


static GnomeVFSResult captive_sandbox_parent_file_seek_slave
		(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSSeekPosition whence,GnomeVFSFileOffset offset)
{
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_seek",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		xmlNewProp(xml_action,BAD_CAST "whence",BAD_CAST
				(whence==GNOME_VFS_SEEK_START ? "start" :
					(whence==GNOME_VFS_SEEK_CURRENT ? "current" :
						(whence==GNOME_VFS_SEEK_END ? "end" : captive_printf_alloca("%lu",(unsigned long)whence)))));
		xmlNewProp(xml_action,BAD_CAST "offset",BAD_CAST captive_printf_alloca("%" G_GINT64_FORMAT,(gint64)offset));
		}

	Captive_File_seek(captive_file_parent_object->corba_File_object,whence,offset,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_seek
		(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSSeekPosition whence,GnomeVFSFileOffset offset)
{
GnomeVFSResult r;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	/* Do not produce 'xml_action' here as we use only 'slave' point of view
	 * for captive-bug-replay(1).
	 */

	switch (whence) {
		case GNOME_VFS_SEEK_START:
			captive_file_parent_object->offset=offset;
			r=GNOME_VFS_OK;
			break;
		case GNOME_VFS_SEEK_CURRENT:
			if (0
					|| (offset>0 && (captive_file_parent_object->offset+offset)<captive_file_parent_object->offset)
					|| (offset<0 && (captive_file_parent_object->offset+offset)>captive_file_parent_object->offset))
				r=GNOME_VFS_ERROR_BAD_PARAMETERS;
			else {
				captive_file_parent_object->offset+=offset;
				r=GNOME_VFS_OK;
				}
			break;
		case GNOME_VFS_SEEK_END:
			g_assert_not_reached();	/* NOT IMPLEMENTED YET */
			r=GNOME_VFS_ERROR_GENERIC;
			break;
		default:
			r=GNOME_VFS_ERROR_BAD_PARAMETERS;
		}

	if (r!=GNOME_VFS_OK)
		return r;

	return GNOME_VFS_OK;
}


#if 0 /* unused */
static GnomeVFSResult captive_sandbox_parent_file_tell_slave
		(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSFileOffset *offset_return)
{
Captive_GnomeVFSFileOffset offset_corba;
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(offset_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,"file_tell",NULL);
		xmlNewProp(xml_action,"object",captive_printf_alloca("%p",captive_file_parent_object));
		}

	Captive_File_tell(captive_file_parent_object->corba_File_object,&offset_corba,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,"result",gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	*offset_return=offset_corba;

	if (xml_action)
		xmlNewProp(xml_action,"offset_return",captive_printf_alloca("%" G_GINT64_FORMAT,(gint64)*offset_return));

	return GNOME_VFS_OK;
}
#endif


GnomeVFSResult captive_sandbox_parent_file_tell(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSFileOffset *offset_return)
{
GnomeVFSResult r;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(offset_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	/* Do not produce 'xml_action' here as we use only 'slave' point of view
	 * for captive-bug-replay(1).
	 */

	*offset_return=captive_file_parent_object->offset;
	r=GNOME_VFS_OK;

	if (r!=GNOME_VFS_OK)
		return r;

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_remove(CaptiveFileParentObject *captive_file_parent_object)
{
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_remove",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		}

	Captive_File_remove(captive_file_parent_object->corba_File_object,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_file_info_get(CaptiveFileParentObject *captive_file_parent_object,
		CaptiveFileInfoObject **captive_file_info_object_return)
{
Captive_CaptiveFileInfoObject *file_info_corba;
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;
CaptiveFileInfoObject *captive_file_info_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(captive_file_info_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_file_info_get",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		}

	Captive_File_file_info_get(captive_file_parent_object->corba_File_object,&file_info_corba,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	r=captive_file_info_object_new(&captive_file_info_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK) {
		Captive_CaptiveFileInfoObject__freekids(file_info_corba,NULL/* 'd'; meaning? */);
		CORBA_free(file_info_corba);
		return r;
		}

	r=captive_sandbox_file_info_corba_to_captive(captive_file_info_object,file_info_corba);
	Captive_CaptiveFileInfoObject__freekids(file_info_corba,NULL/* 'd'; meaning? */);
	CORBA_free(file_info_corba);
	if (xml_action)
		xmlSetProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK) {
		g_object_unref(captive_file_info_object);
		return r;
		}

	*captive_file_info_object_return=captive_file_info_object;
	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_file_info_set(CaptiveFileParentObject *captive_file_parent_object,
    CaptiveFileInfoObject *file_info_captive,GnomeVFSSetFileInfoMask mask)
{
Captive_CaptiveFileInfoObject file_info_corba;
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(file_info_captive!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_file_info_set",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		xmlNewProp(xml_action,BAD_CAST "mask",BAD_CAST captive_printf_alloca("%u",(unsigned)mask));
		}

	if (GNOME_VFS_OK!=(r=captive_sandbox_file_info_set_mask_captive_to_corba(&file_info_corba,file_info_captive,mask)))
		return r;

	Captive_File_file_info_set(captive_file_parent_object->corba_File_object,&file_info_corba,mask,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	Captive_CaptiveFileInfoObject__freekids(&file_info_corba,NULL/* 'd'; meaning? */);

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_truncate(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSFileSize file_size)
{
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(CAPTIVE_FILE_PARENT_IS_OBJECT(captive_file_parent_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_truncate",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object));
		xmlNewProp(xml_action,BAD_CAST "file_size",BAD_CAST captive_printf_alloca("%" G_GUINT64_FORMAT,(guint64)file_size));
		}

	Captive_File_truncate(captive_file_parent_object->corba_File_object,file_size,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_sandbox_parent_file_move
		(CaptiveFileParentObject *captive_file_parent_object_old,const gchar *pathname_new,gboolean force_replace)
{
GnomeVFSResult r;
xmlNode *xml_action=NULL;
CaptiveVfsParentObject *captive_vfs_parent_object;

	g_return_val_if_fail(captive_file_parent_object_old!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname_new!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_parent_object=CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_FILE_OBJECT(captive_file_parent_object_old)->vfs);

	if (captive_vfs_parent_object->corba_bug_action) {
		xml_action=xmlNewTextChild(captive_vfs_parent_object->corba_bug_action,NULL,BAD_CAST "file_move",NULL);
		xmlNewProp(xml_action,BAD_CAST "object",BAD_CAST captive_printf_alloca("%p",captive_file_parent_object_old));
		xmlNewProp(xml_action,BAD_CAST "pathname_new",BAD_CAST pathname_new);
		xmlNewProp(xml_action,BAD_CAST "force_replace",BAD_CAST captive_printf_alloca("%u",(unsigned)force_replace));
		}

	Captive_File_move(captive_file_parent_object_old->corba_File_object,pathname_new,force_replace,&captive_corba_ev);
	r=captive_sandbox_parent_return_from_CORBA_Environment(&captive_corba_ev,captive_vfs_parent_object);
	if (xml_action)
		xmlNewProp(xml_action,BAD_CAST "result",BAD_CAST gnome_vfs_result_to_string(r));
	if (r!=GNOME_VFS_OK)
		return r;

	return GNOME_VFS_OK;
}
