/* $Id: parent-File.h,v 1.3 2006/01/01 07:24:34 lace Exp $
 * Include file for CORBA/ORBit server side of File object of sandbox_parent()
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _PARENT_FILE_H
#define _PARENT_FILE_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-result.h>	/* for GnomeVFSResult */
#include "../client/file-parent.h"


G_BEGIN_DECLS

GnomeVFSResult captive_sandbox_parent_file_new_open(CaptiveFileParentObject *captive_file_parent_object);
GnomeVFSResult captive_sandbox_parent_file_new_create(CaptiveFileParentObject *captive_file_parent_object,
		gboolean exclusive,guint perm);
GnomeVFSResult captive_sandbox_parent_file_close(CaptiveFileParentObject *captive_file_parent_object);
GnomeVFSResult captive_sandbox_parent_file_read(CaptiveFileParentObject *captive_file_parent_object,
		gpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_read_return);
GnomeVFSResult captive_sandbox_parent_file_write(CaptiveFileParentObject *captive_file_parent_object,
		gconstpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_written_return);
GnomeVFSResult captive_sandbox_parent_file_seek
		(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSSeekPosition whence,GnomeVFSFileOffset offset);
GnomeVFSResult captive_sandbox_parent_file_tell
		(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSFileOffset *offset_return);
GnomeVFSResult captive_sandbox_parent_file_remove(CaptiveFileParentObject *captive_file_parent_object);
GnomeVFSResult captive_sandbox_parent_file_file_info_get(CaptiveFileParentObject *captive_file_parent_object,
		CaptiveFileInfoObject **captive_file_info_object_return);
GnomeVFSResult captive_sandbox_parent_file_file_info_set(CaptiveFileParentObject *captive_file_parent_object,
    CaptiveFileInfoObject *file_info_captive,GnomeVFSSetFileInfoMask mask);
GnomeVFSResult captive_sandbox_parent_file_truncate
		(CaptiveFileParentObject *captive_file_parent_object,GnomeVFSFileSize file_size);
GnomeVFSResult captive_sandbox_parent_file_move
		(CaptiveFileParentObject *captive_file_parent_object_old,const gchar *pathname_new,gboolean force_replace);

G_END_DECLS


#endif /* _PARENT_FILE_H */
