/* $Id: server-CaptiveIOChannel.c,v 1.3 2005/12/17 05:33:48 lace Exp $
 * CORBA/ORBit client side of image GIOChannel object of sandbox_child()
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "server-CaptiveIOChannel.h"	/* self */
#include "sandbox.h"
#include <glib/gmessages.h>
#include "captive/macros.h"
#include "split.h"
#include <libgnomevfs/gnome-vfs-file-size.h>
#include "captive/storage.h"


static void impl_Captive_CaptiveIOChannel_fini(impl_POA_Captive_CaptiveIOChannel *servant,CORBA_Environment *ev);
static void impl_Captive_CaptiveIOChannel_read(impl_POA_Captive_CaptiveIOChannel *servant,
		Captive_Bytes **buffer_corba_return,const Captive_GSize count,CORBA_Environment *ev);
static void impl_Captive_CaptiveIOChannel_write(impl_POA_Captive_CaptiveIOChannel *servant,
		const Captive_Bytes *buffer,Captive_GSize *bytes_written_return,CORBA_Environment *ev);
static void impl_Captive_CaptiveIOChannel_seek
		(impl_POA_Captive_CaptiveIOChannel *servant,const Captive_GInt64 offset,const Captive_GSeekType type,CORBA_Environment *ev);
static Captive_GUInt64 impl_Captive_CaptiveIOChannel_size(impl_POA_Captive_CaptiveIOChannel *servant,CORBA_Environment *ev);


static PortableServer_ServantBase__epv impl_Captive_CaptiveIOChannel_base_epv={
	NULL,	/* _private data */
	(gpointer)&impl_Captive_CaptiveIOChannel_fini,	/* finalize routine */
	NULL,	/* default_POA routine */
	};
static POA_Captive_CaptiveIOChannel__epv impl_Captive_CaptiveIOChannel_epv={
	NULL,	/* _private */
	(gpointer)&impl_Captive_CaptiveIOChannel_read,
	(gpointer)&impl_Captive_CaptiveIOChannel_write,
	(gpointer)&impl_Captive_CaptiveIOChannel_seek,
	(gpointer)&impl_Captive_CaptiveIOChannel_size,
	};
static POA_Captive_CaptiveIOChannel__vepv impl_Captive_CaptiveIOChannel_vepv={
	&impl_Captive_CaptiveIOChannel_base_epv,
	&impl_Captive_CaptiveIOChannel_epv,
	};


Captive_CaptiveIOChannel impl_Captive_CaptiveIOChannel__create
		(PortableServer_POA poa,GIOChannel *image_iochannel,CORBA_Environment *ev)
{
Captive_CaptiveIOChannel retval;
impl_POA_Captive_CaptiveIOChannel *newservant;
PortableServer_ObjectId *objid;

	captive_new0(newservant);	/* FIXME: leak */
	newservant->servant.vepv=&impl_Captive_CaptiveIOChannel_vepv;
	newservant->poa=poa;

	newservant->image_iochannel=image_iochannel;

	/* captive_giochannel_size() only _after_ g_io_channel_set_encoding() ! */
	newservant->image_size=captive_giochannel_size(newservant->image_iochannel);
	g_return_val_if_fail(newservant->image_size>0,NULL);

	POA_Captive_CaptiveIOChannel__init((PortableServer_Servant)newservant,ev);
	objid=PortableServer_POA_activate_object(poa,newservant,ev);
	CORBA_free(objid);
	retval=PortableServer_POA_servant_to_reference(poa,newservant,ev);

	return retval;
}


static void impl_Captive_CaptiveIOChannel_fini(impl_POA_Captive_CaptiveIOChannel *servant,CORBA_Environment *ev)
{
	/* FIXME: Any flushes? */
}


void impl_Captive_CaptiveIOChannel__destroy(impl_POA_Captive_CaptiveIOChannel *servant,CORBA_Environment *ev)
{
PortableServer_ObjectId *objid;

	objid=PortableServer_POA_servant_to_id(servant->poa,servant,ev);
	PortableServer_POA_deactivate_object(servant->poa,objid,ev);
	CORBA_free(objid);
	impl_Captive_CaptiveIOChannel_fini(servant,ev);
	g_free(servant);
}


static void impl_Captive_CaptiveIOChannel_read(impl_POA_Captive_CaptiveIOChannel *servant,
		Captive_Bytes **buffer_corba_return,const Captive_GSize count,CORBA_Environment *ev)
{
Captive_Bytes *buffer_corba;
gsize bytes_read;
GIOStatus erriostatus;

	buffer_corba=Captive_Bytes__alloc();
	buffer_corba->_maximum=count;
	buffer_corba->_length=0;
	buffer_corba->_buffer=Captive_Bytes_allocbuf(buffer_corba->_maximum);
	buffer_corba->_release=TRUE;

	erriostatus=g_io_channel_read_chars(servant->image_iochannel,
			(gchar *)buffer_corba->_buffer,	/* buf */
			count,	/* count */
			&bytes_read,	/* bytes_read */
			NULL);	/* error */
	if (erriostatus==G_IO_STATUS_EOF) {
		g_assert(bytes_read==0);
		bytes_read=0;
		erriostatus=G_IO_STATUS_NORMAL;
		}
	if (erriostatus!=G_IO_STATUS_NORMAL) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,GNOME_VFS_ERROR_IO);
		Captive_Bytes__freekids(buffer_corba,NULL/* 'd'; meaning? */);
		CORBA_free(buffer_corba);
		return;
		}

	buffer_corba->_length=bytes_read;
	*buffer_corba_return=buffer_corba;
}


static void impl_Captive_CaptiveIOChannel_write(impl_POA_Captive_CaptiveIOChannel *servant,
		const Captive_Bytes *buffer_corba,Captive_GSize *bytes_written_return,CORBA_Environment *ev)
{
gsize bytes_written;

	if (G_IO_STATUS_NORMAL!=g_io_channel_write_chars(servant->image_iochannel,
			(const gchar *)buffer_corba->_buffer,	/* buf */
			buffer_corba->_length,	/* count */
			&bytes_written,	/* bytes_written */
			NULL)	/* error */
					|| bytes_written!=buffer_corba->_length) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,GNOME_VFS_ERROR_IO);
		return;
		}

	*bytes_written_return=bytes_written;
}


static void impl_Captive_CaptiveIOChannel_seek
		(impl_POA_Captive_CaptiveIOChannel *servant,const Captive_GInt64 offset,const Captive_GSeekType type,CORBA_Environment *ev)
{
	if (G_IO_STATUS_NORMAL!=g_io_channel_seek_position(servant->image_iochannel,
			offset,	/* offset */
			type,	/* type */
			NULL)) {	/* error */
		captive_sandbox_child_GnomeVFSResultException_throw(ev,GNOME_VFS_ERROR_IO);
		return;
		}
}


static Captive_GUInt64 impl_Captive_CaptiveIOChannel_size(impl_POA_Captive_CaptiveIOChannel *servant,CORBA_Environment *ev)
{
	return servant->image_size;
}
