/* $Id: server-Directory.c,v 1.7 2006/01/01 07:24:34 lace Exp $
 * CORBA/ORBit server side of Directory object, ran by sandbox_child()
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "server-Directory.h"	/* self */
#include "sandbox.h"
#include <glib/gmessages.h>
#include "captive/macros.h"
#include "../client/directory.h"
#include "FileInfo.h"
#include "split.h"
#include "../client/vfs-slave.h"


static void impl_Captive_Directory_fini(impl_POA_Captive_Directory *servant,CORBA_Environment *ev);
static void impl_Captive_Directory_read
		(impl_POA_Captive_Directory *servant,Captive_CaptiveFileInfoObject **file_info,CORBA_Environment *ev);
static void impl_Captive_Directory_remove(impl_POA_Captive_Directory *servant,CORBA_Environment *ev);
static void impl_Captive_Directory_shutdown(impl_POA_Captive_Directory *servant,CORBA_Environment *ev);


static PortableServer_ServantBase__epv impl_Captive_Directory_base_epv={
	NULL,	/* _private data */
	(gpointer)&impl_Captive_Directory_fini,	/* finalize routine */
	NULL,	/* default_POA routine */
	};
static POA_Captive_Directory__epv impl_Captive_Directory_epv={
	NULL,	/* _private */
	(gpointer)&impl_Captive_Directory_read,
	(gpointer)&impl_Captive_Directory_remove,
	(gpointer)&impl_Captive_Directory_shutdown,
	};
static POA_Captive_Directory__vepv impl_Captive_Directory_vepv={
	&impl_Captive_Directory_base_epv,
	&impl_Captive_Directory_epv,
	};


Captive_Directory impl_Captive_Directory__create(PortableServer_POA poa,CORBA_Environment *ev)
{
Captive_Directory retval;
impl_POA_Captive_Directory *newservant;
PortableServer_ObjectId *objid;

	captive_new0(newservant);	/* FIXME: leak */
	newservant->servant.vepv=&impl_Captive_Directory_vepv;
	newservant->poa=poa;
	newservant->captive_directory_object=NULL;
	POA_Captive_Directory__init((PortableServer_Servant)newservant,ev);
	objid=PortableServer_POA_activate_object(poa,newservant,ev);
	CORBA_free(objid);
	retval=PortableServer_POA_servant_to_reference(poa,newservant,ev);

	return retval;
}


static void impl_Captive_Directory_fini(impl_POA_Captive_Directory *servant,CORBA_Environment *ev)
{
	if (servant->captive_directory_object) {
		g_object_unref(servant->captive_directory_object);
		servant->captive_directory_object=NULL;
		}
}


static void impl_Captive_Directory__destroy(impl_POA_Captive_Directory *servant,CORBA_Environment *ev)
{
PortableServer_ObjectId *objid;

	objid=PortableServer_POA_servant_to_id(servant->poa,servant,ev);
	PortableServer_POA_deactivate_object(servant->poa,objid,ev);
	CORBA_free(objid);
	impl_Captive_Directory_fini(servant,ev);
	g_free(servant);
}


Captive_Directory impl_Captive_Vfs_directory_new_open
		(impl_POA_Captive_Vfs *servant,const CORBA_char *pathname,CORBA_Environment *ev)
{
Captive_Directory retval;
impl_POA_Captive_Directory *retval_servant;
GnomeVFSResult errvfsresult;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(servant->captive_vfs_object),NULL);	/* not yet initialized? */

	retval=impl_Captive_Directory__create(servant->poa,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;

	retval_servant=PortableServer_POA_reference_to_servant(servant->poa,retval,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;	/* 'retval' leak */

	if (GNOME_VFS_OK!=(errvfsresult=captive_directory_new_open(&retval_servant->captive_directory_object,
			servant->captive_vfs_object,pathname))) {
		impl_Captive_Directory__destroy(retval_servant,ev);
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return NULL;
		}

	return retval;
}


Captive_Directory impl_Captive_Vfs_directory_new_make(impl_POA_Captive_Vfs *servant,
		const CORBA_char *pathname,const Captive_GnomeVFSFilePermissions perm,CORBA_Environment *ev)
{
Captive_Directory retval;
impl_POA_Captive_Directory *retval_servant;
GnomeVFSResult errvfsresult;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(servant->captive_vfs_object),NULL);	/* not yet initialized? */

	retval=impl_Captive_Directory__create(servant->poa,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;

	retval_servant=PortableServer_POA_reference_to_servant(servant->poa,retval,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;	/* 'retval' leak */

	if (GNOME_VFS_OK!=(errvfsresult=captive_directory_new_make(&retval_servant->captive_directory_object,
			servant->captive_vfs_object,pathname,perm))) {
		impl_Captive_Directory__destroy(retval_servant,ev);
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return NULL;
		}

	return retval;
}


static void impl_Captive_Directory_read
		(impl_POA_Captive_Directory *servant,Captive_CaptiveFileInfoObject **file_info_corba_return,CORBA_Environment *ev)
{
CaptiveFileInfoObject *file_info_captive;
Captive_CaptiveFileInfoObject *file_info_corba;
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_directory_read(servant->captive_directory_object,&file_info_captive))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}

	file_info_corba=Captive_CaptiveFileInfoObject__alloc();

	errvfsresult=captive_sandbox_file_info_captive_to_corba(file_info_corba,file_info_captive);
	g_object_unref(file_info_captive);

	if (GNOME_VFS_OK!=errvfsresult) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		Captive_CaptiveFileInfoObject__freekids(file_info_corba,NULL/* 'd'; meaning? */);
		CORBA_free(file_info_corba);
		return;
		}

	*file_info_corba_return=file_info_corba;
}


static void impl_Captive_Directory_remove(impl_POA_Captive_Directory *servant,CORBA_Environment *ev)
{
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_directory_remove(servant->captive_directory_object))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}
}


static gboolean impl_Captive_Directory_shutdown_idle(impl_POA_Captive_Directory *servant /* data */)
{
	impl_Captive_Directory__destroy(servant,&captive_corba_ev);
	g_assert(validate_CORBA_Environment(&captive_corba_ev));

	return FALSE;	/* remove me */
}

static void impl_Captive_Directory_shutdown(impl_POA_Captive_Directory *servant,CORBA_Environment *ev)
{
GSource *source;

	/* Shutdown 'servant->captive_directory_object' synchronously as it may
	 * flush its buffers needed to be transferred to our parent.
	 */
	impl_Captive_Directory_fini(servant,&captive_corba_ev);
	g_assert(validate_CORBA_Environment(&captive_corba_ev));

	/* Do not call impl_Captive_Directory__destroy() directly as we would fail
	 * to finish this CORBA method call properly.
	 * Do not call g_idle_add_full() as it would miss linc main loop.
	 * FIXME: STATUS_SHARING_VIOLATION error during batch processing.
	 *  - probably exclusive access to be changed to shareable one
	 */
  source=g_idle_source_new ();
	g_source_set_priority(source,G_PRIORITY_LOW);
  g_source_set_callback(
			source,	/* source */
			(GSourceFunc)impl_Captive_Directory_shutdown_idle,	/* func */
			servant,	/* data */
			NULL);	/* notify */
  g_source_attach(source,
			captive_corba_get_context());	/* context; NULL means 'default context' */
  g_source_unref(source);
}
