/* $Id: server-File.c,v 1.7 2006/01/01 10:07:09 lace Exp $
 * CORBA/ORBit server side of File object, ran by sandbox_child()
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "server-File.h"	/* self */
#include "sandbox.h"
#include <glib/gmessages.h>
#include "captive/macros.h"
#include "split.h"
#include "FileInfo.h"
#include "../client/vfs-slave.h"


static void impl_Captive_File_fini(impl_POA_Captive_File *servant,CORBA_Environment *ev);
static void impl_Captive_File_read(impl_POA_Captive_File *servant,Captive_Bytes **buffer,
		const Captive_GnomeVFSFileSize num_bytes,CORBA_Environment *ev);
static void impl_Captive_File_write(impl_POA_Captive_File *servant,
		const Captive_Bytes *buffer,Captive_GnomeVFSFileSize *bytes_written_return,CORBA_Environment *ev);
static void impl_Captive_File_seek(impl_POA_Captive_File *servant,
		const Captive_GnomeVFSSeekPosition whence,const Captive_GnomeVFSFileOffset offset,CORBA_Environment *ev);
static void impl_Captive_File_tell
		(impl_POA_Captive_File *servant,Captive_GnomeVFSFileOffset *offset_return,CORBA_Environment *ev);
static void impl_Captive_File_remove(impl_POA_Captive_File *servant,CORBA_Environment *ev);
static void impl_Captive_File_file_info_get
		(impl_POA_Captive_File *servant,Captive_CaptiveFileInfoObject **file_info,CORBA_Environment *ev);
static void impl_Captive_File_file_info_set(impl_POA_Captive_File *servant,
		const Captive_CaptiveFileInfoObject *file_info,const Captive_GnomeVFSSetFileInfoMask mask,CORBA_Environment *ev);
static void impl_Captive_File_truncate
		(impl_POA_Captive_File *servant,const Captive_GnomeVFSFileSize file_size,CORBA_Environment *ev);
static void impl_Captive_File_move
		(impl_POA_Captive_File *servant,const CORBA_char *pathname_new,const CORBA_boolean force_replace,CORBA_Environment *ev);
static void impl_Captive_File_shutdown(impl_POA_Captive_File *servant,CORBA_Environment *ev);


static PortableServer_ServantBase__epv impl_Captive_File_base_epv={
	NULL,	/* _private data */
	(gpointer)&impl_Captive_File_fini,	/* finalize routine */
	NULL,	/* default_POA routine */
	};
static POA_Captive_File__epv impl_Captive_File_epv={
	NULL,	/* _private */
	(gpointer)&impl_Captive_File_read,
	(gpointer)&impl_Captive_File_write,
	(gpointer)&impl_Captive_File_seek,
	(gpointer)&impl_Captive_File_tell,
	(gpointer)&impl_Captive_File_remove,
	(gpointer)&impl_Captive_File_file_info_get,
	(gpointer)&impl_Captive_File_file_info_set,
	(gpointer)&impl_Captive_File_truncate,
	(gpointer)&impl_Captive_File_move,
	(gpointer)&impl_Captive_File_shutdown,
	};
static POA_Captive_File__vepv impl_Captive_File_vepv={
	&impl_Captive_File_base_epv,
	&impl_Captive_File_epv,
	};


Captive_File impl_Captive_File__create(PortableServer_POA poa,CORBA_Environment *ev)
{
Captive_File retval;
impl_POA_Captive_File *newservant;
PortableServer_ObjectId *objid;

	captive_new0(newservant);	/* FIXME: leak */
	newservant->servant.vepv=&impl_Captive_File_vepv;
	newservant->poa=poa;
	newservant->captive_file_object=NULL;
	POA_Captive_File__init((PortableServer_Servant)newservant,ev);
	objid=PortableServer_POA_activate_object(poa,newservant,ev);
	CORBA_free(objid);
	retval=PortableServer_POA_servant_to_reference(poa,newservant,ev);

	return retval;
}


static void impl_Captive_File_fini(impl_POA_Captive_File *servant,CORBA_Environment *ev)
{
	if (servant->captive_file_object) {
		g_object_unref(servant->captive_file_object);
		servant->captive_file_object=NULL;
		}
}


static void impl_Captive_File__destroy(impl_POA_Captive_File *servant,CORBA_Environment *ev)
{
PortableServer_ObjectId *objid;

	objid=PortableServer_POA_servant_to_id(servant->poa,servant,ev);
	PortableServer_POA_deactivate_object(servant->poa,objid,ev);
	CORBA_free(objid);
	impl_Captive_File_fini(servant,ev);
	g_free(servant);
}


Captive_File impl_Captive_Vfs_file_new_open
		(impl_POA_Captive_Vfs *servant,const CORBA_char *pathname,const Captive_GnomeVFSOpenMode mode,CORBA_Environment *ev)
{
Captive_File retval;
impl_POA_Captive_File *retval_servant;
GnomeVFSResult errvfsresult;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(servant->captive_vfs_object),NULL);	/* not yet initialized? */

	retval=impl_Captive_File__create(servant->poa,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;

	retval_servant=PortableServer_POA_reference_to_servant(servant->poa,retval,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;	/* 'retval' leak */

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_new_open(&retval_servant->captive_file_object,
			servant->captive_vfs_object,pathname,mode))) {
		impl_Captive_File__destroy(retval_servant,ev);
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return NULL;
		}

	return retval;
}


Captive_File impl_Captive_Vfs_file_new_create(impl_POA_Captive_Vfs *servant,const CORBA_char *pathname,
		const Captive_GnomeVFSOpenMode mode,const CORBA_boolean exclusive,const CORBA_unsigned_long perm,CORBA_Environment *ev)
{
Captive_File retval;
impl_POA_Captive_File *retval_servant;
GnomeVFSResult errvfsresult;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(servant->captive_vfs_object),NULL);	/* not yet initialized? */

	retval=impl_Captive_File__create(servant->poa,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;

	retval_servant=PortableServer_POA_reference_to_servant(servant->poa,retval,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return NULL;	/* 'retval' leak */

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_new_create(&retval_servant->captive_file_object,
			servant->captive_vfs_object,pathname,mode,exclusive,perm))) {
		impl_Captive_File__destroy(retval_servant,ev);
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return NULL;
		}

	return retval;
}


static void impl_Captive_File_read(impl_POA_Captive_File *servant,Captive_Bytes **buffer_corba_return,
		const Captive_GnomeVFSFileSize num_bytes,CORBA_Environment *ev)
{
Captive_Bytes *buffer_corba;
GnomeVFSFileSize bytes_read;
GnomeVFSResult errvfsresult;

	buffer_corba=Captive_Bytes__alloc();
	buffer_corba->_maximum=num_bytes;
	buffer_corba->_length=0;
	buffer_corba->_buffer=Captive_Bytes_allocbuf(buffer_corba->_maximum);
	buffer_corba->_release=TRUE;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_read(servant->captive_file_object,
			buffer_corba->_buffer,num_bytes,&bytes_read))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		Captive_Bytes__freekids(buffer_corba,NULL/* 'd'; meaning? */);
		CORBA_free(buffer_corba);
		return;
		}

	buffer_corba->_length=bytes_read;
	*buffer_corba_return=buffer_corba;
}


static void impl_Captive_File_write(impl_POA_Captive_File *servant,
		const Captive_Bytes *buffer_corba,Captive_GnomeVFSFileSize *bytes_written_return,CORBA_Environment *ev)
{
GnomeVFSFileSize bytes_written;
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_write(servant->captive_file_object,
			buffer_corba->_buffer,buffer_corba->_length,&bytes_written))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}

	*bytes_written_return=bytes_written;
}


static void impl_Captive_File_seek(impl_POA_Captive_File *servant,
		const Captive_GnomeVFSSeekPosition whence,const Captive_GnomeVFSFileOffset offset,CORBA_Environment *ev)
{
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_seek(servant->captive_file_object,whence,offset))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}
}


static void impl_Captive_File_tell
		(impl_POA_Captive_File *servant,Captive_GnomeVFSFileOffset *offset_return,CORBA_Environment *ev)
{
GnomeVFSFileOffset offset_captive;
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_tell(servant->captive_file_object,&offset_captive))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}
	
	*offset_return=offset_captive;
}


static void impl_Captive_File_remove(impl_POA_Captive_File *servant,CORBA_Environment *ev)
{
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_remove(servant->captive_file_object))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}
}


static void impl_Captive_File_file_info_get
		(impl_POA_Captive_File *servant,Captive_CaptiveFileInfoObject **file_info_corba_return,CORBA_Environment *ev)
{
CaptiveFileInfoObject *file_info_captive;
GnomeVFSResult errvfsresult;
Captive_CaptiveFileInfoObject *file_info_corba;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_file_info_get(servant->captive_file_object,&file_info_captive))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}

	file_info_corba=Captive_CaptiveFileInfoObject__alloc();

	errvfsresult=captive_sandbox_file_info_captive_to_corba(file_info_corba,file_info_captive);
	g_object_unref(file_info_captive);

	if (GNOME_VFS_OK!=errvfsresult) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		Captive_CaptiveFileInfoObject__freekids(file_info_corba,NULL/* 'd'; meaning? */);
		CORBA_free(file_info_corba);
		return;
		}

	*file_info_corba_return=file_info_corba;
}


static void impl_Captive_File_file_info_set(impl_POA_Captive_File *servant,
		const Captive_CaptiveFileInfoObject *file_info_corba,const Captive_GnomeVFSSetFileInfoMask mask,CORBA_Environment *ev)
{
CaptiveFileInfoObject *file_info_captive;
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_info_object_new(&file_info_captive))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}

	if (GNOME_VFS_OK!=(errvfsresult=captive_sandbox_file_info_corba_to_captive(
			file_info_captive,file_info_corba))) {
		g_object_unref(file_info_captive);
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}

	errvfsresult=captive_file_file_info_set(servant->captive_file_object,file_info_captive,mask);
	g_object_unref(file_info_captive);

	if (GNOME_VFS_OK!=errvfsresult) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}
}


static void impl_Captive_File_truncate
		(impl_POA_Captive_File *servant,const Captive_GnomeVFSFileSize file_size,CORBA_Environment *ev)
{
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_truncate(servant->captive_file_object,file_size))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}
}


static void impl_Captive_File_move
		(impl_POA_Captive_File *servant,const CORBA_char *pathname_new,const CORBA_boolean force_replace,CORBA_Environment *ev)
{
GnomeVFSResult errvfsresult;

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_move(servant->captive_file_object,pathname_new,force_replace))) {
		captive_sandbox_child_GnomeVFSResultException_throw(ev,errvfsresult);
		return;
		}
}


static gboolean impl_Captive_File_shutdown_idle(impl_POA_Captive_File *servant /* data */)
{
	impl_Captive_File__destroy(servant,&captive_corba_ev);
	g_assert(validate_CORBA_Environment(&captive_corba_ev));

	return FALSE;	/* remove me */
}

static void impl_Captive_File_shutdown(impl_POA_Captive_File *servant,CORBA_Environment *ev)
{
GSource *source;

	/* Shutdown 'servant->captive_file_object' synchronously as it may
	 * flush its buffers needed to be transferred to our parent.
	 */
	impl_Captive_File_fini(servant,&captive_corba_ev);
	g_assert(validate_CORBA_Environment(&captive_corba_ev));

	/* Do not call impl_Captive_File__destroy() directly as we would fail
	 * to finish this CORBA method call properly.
	 * Do not call g_idle_add_full() as it would miss linc main loop.
	 * FIXME: STATUS_SHARING_VIOLATION error during batch processing.
	 *  - probably exclusive access to be changed to shareable one
	 */
  source=g_idle_source_new ();
	g_source_set_priority(source,G_PRIORITY_LOW);
  g_source_set_callback(
			source,	/* source */
			(GSourceFunc)impl_Captive_File_shutdown_idle,	/* func */
			servant,	/* data */
			NULL);	/* notify */
  g_source_attach(source,
			captive_corba_get_context());	/* context; NULL means 'default context' */
  g_source_unref(source);
}
